#ifndef __META_H
#define __META_H

#include "includes.h"
#include "core.h"
#include "sensors.h"
#include "filters.h"

class Modulator {
public:
    Modulator(Inverter *inverter) {_inverter = inverter;}
    virtual void Update(float valpha, float vbeta) = 0;
protected:
    Inverter* _inverter;
};

class SinusoidalModulator: public Modulator {
public:
    SinusoidalModulator(Inverter *inverter):Modulator(inverter) {}
    virtual void Update(float valpha, float vbeta);
};

class SvmModulator: public Modulator {
public:
    SvmModulator(Inverter *inverter):Modulator(inverter) {}
    virtual void Update(float valpha, float vbeta);
};

class ReferenceSynthesizer {
public:
    ReferenceSynthesizer(float max_phase_current) {_max_phase_current = max_phase_current;}
    virtual void GetReference(float angle, float throttle, float *ref_d, float *ref_q) {*ref_d = 0; *ref_q = 0;}
protected:
    static float LutSin(float theta);
    static float LutCos(float theta);
protected:
    float _max_phase_current;
};

class SynchronousReferenceSynthesizer : public ReferenceSynthesizer {
public:
    SynchronousReferenceSynthesizer(float max_phase_current):ReferenceSynthesizer(max_phase_current) {}
    virtual void GetReference(float angle, float throttle, float *ref_d, float *ref_q);
};

#endif

