#include "includes.h"
#include "sensors.h"

AnalogCurrentSensor::AnalogCurrentSensor(PinName pin, float volts_per_amp) {
    _in = new AnalogIn(pin);
    _volts_per_amp = volts_per_amp;
    wait_us(100000);
    Zero();
}

void AnalogCurrentSensor::Zero() {
    float mean = 0;
    for(int i = 0; i < 1000; i++){
        mean += (float) *_in;
    }
    _zero_level = mean / 1000;
}

float AnalogCurrentSensor::GetCurrent() {
    return ((float) *_in - _zero_level) * 3.3f / _volts_per_amp;
}