#include "constants.h"
#include "shared.h"
#include "isr.h"
#include <stdlib.h>

void initTimers() {
#ifdef __USE_THROTTLE
    dtc_upd_ticker.attach_us(&dtc_update, 200);
    throttle_upd_ticker.attach_us(&throttle_update, 100000);
    isense_upd_ticker.attach_us(&isense_update,1000);
#endif

#ifndef __NATIVE
    pha.period_us(100);
    phb.period_us(100);
    phc.period_us(100);
    pha = 0;
    phb = 1.0f;
    phc = 0;
#endif

    TIM2->CR1 &= ~(TIM_CR1_CEN);
    TIM2->CR1 |= TIM_CR1_CMS;
    
#ifdef __NATIVE
    TIM2->CCMR1 |= TIM_CCMR1_OC1M_2;
    TIM2->CCMR1 |= TIM_CCMR1_OC1M_1;
    TIM2->CCMR1 |= TIM_CCMR1_OC2M_2;
    TIM2->CCMR1 |= TIM_CCMR1_OC2M_1;
    TIM2->CCMR2 |= TIM_CCMR2_OC3M_2;
    TIM2->CCMR2 |= TIM_CCMR2_OC3M_1;
    
    TIM2->CCER &= ~TIM_CCER_CC1P;
    TIM2->CCER &= ~TIM_CCER_CC2P;
    TIM2->CCER &= ~TIM_CCER_CC3P;
    
    TIM2->CCER |= TIM_CCER_CC1E;
    TIM2->CCER |= TIM_CCER_CC2E;
    TIM2->CCER |= TIM_CCER_CC3E;
    
    TIM2->PSC = 0;
    
    TIM2->ARR = 10000;
    TIM2->CCR1 = 0;
    TIM2->CCR2 = 0;
    TIM2->CCR3 = 0;
#endif

    TIM2->CR1 |= TIM_CR1_CEN;
}

void initPins() {        
    en = 0;
}

void initData() {
    motor = (Motor*) malloc(sizeof(Motor));
    motor->sensor_phase = SENSOR_PHASE;
    motor->halt = 0;
    motor->angle = 0;
    motor->debug_stop = 0;

#ifdef __USE_THROTTLE
    float throttle_raw;
    do {
        throttle_raw = throttle;
        throttle_raw = (throttle_raw - THROTTLE_DB) / (1.0f - THROTTLE_DB);
        if (throttle_raw < 0.0f) throttle_raw = 0.0f;
    } while (throttle_raw > 0.05f);
    
    motor->throttle = (1.0f - THROTTLE_LPF) * throttle_raw + THROTTLE_LPF * motor->throttle;
    if (motor->throttle < 0.05f & abs(motor->speed) < 1.0f) {
        motor->halt = 1;
    } else {
        motor->halt = 0;
    }
#else
    motor->throttle = 1.0f;
#endif
}

void setDtcA(float f) {
#ifdef __NATIVE
    TIM2->CCR3 = (uint16_t) (f * 10000.0f);
#else
    pha = f;
#endif
}

void setDtcB(float f) {
#ifdef __NATIVE
    TIM2->CCR1 = (uint16_t) (f * 10000.0f);
#else
    phb = f;
#endif
}

void setDtcC(float f) {
#ifdef __NATIVE
    TIM2->CCR2 = (uint16_t) (f * 10000.0f);
#else
    phc = f;
#endif
}