#include "includes.h"
#include "meta.h"

void SinusoidalModulator::Update(float va, float vb) {
    _inverter->va = va;
    _inverter->vb = vb;
    
    _inverter->SetDtcB(va/2.0f + 0.5f);
    _inverter->SetDtcC((-va / 2.0f - sqrt(3.0f) / 2.0f * vb)/2.0f + 0.5f);
    _inverter->SetDtcA((-va / 2.0f + sqrt(3.0f) / 2.0f * vb)/2.0f + 0.5f);
    
    
    test_DtcB = va;
    test_DtcC = -va / 2.0f - sqrt(3.0f) / 2.0f * vb;
    test_DtcA = -va / 2.0f + sqrt(3.0f) / 2.0f * vb;
    
    
    /*
    _inverter->SetDtcA(1.0f);
    _inverter->SetDtcB(0.5f);
    _inverter->SetDtcC(1.0f);
    */
}