#include "includes.h"
#include "meta.h"
#include "lut.h"

void SynchronousReferenceSynthesizer::GetReference(float angle, float *ref_d, float *ref_q) {
    *ref_d = _max_phase_current * LutSin(angle);
    *ref_q = 0.0f;
}

float ReferenceSynthesizer::LutSin(float theta) {
    if (theta < 0.0f) theta += 360.0f;
    if (theta >= 360.0f) theta -= 360.0f;
    return sinetab[(int) theta] * 2.0f - 1.0f;
}

float ReferenceSynthesizer::LutCos(float theta) {
    return LutSin(90.0f - theta);
}