#include "includes.h"
#include "core.h"
#include "sensors.h"
#include "meta.h"

void txCallback() {
}
 
// This function is called when a character goes into the RX buffer.
void rxCallback() {
    if(pc->getc()=='r'){
        acquire = 1;
        pc->putc('3');
    }
    if((pc->getc()=='d')&(acquire==0)&(_user->throttle==0)){
        for (int i = 0; i < 10000; i++) {
            pc->printf("%f,", fbuffer[i]);
        }
    }
    pc->putc(pc->getc());
}
 

    



Serial *pc = new Serial(SERIAL_TX, SERIAL_RX);
float test_alpha = 0;
float test_beta = 0;

float d_mean = 0;
float q_mean = 0;

float test_DtcA;
float test_DtcB;
float test_DtcC;

float *fbuffer;
int acquire = 0;
int bufidx = 0;
int bufsize = 10000;
int skip = 0;

int main() {
    pc->baud(115200);
    pc->attach(&txCallback, Serial::TxIrq);
    pc->attach(&rxCallback, Serial::RxIrq);
    pc->printf("%s\n\r", "Init Serial Comm");

    fbuffer = (float*)malloc(bufsize*sizeof(float));
    
    PositionSensor *sense_p = new AnalogHallPositionSensor(A4, A5, 0.249f, 0.497f, 0.231f, 0.499f, 205.0f);
    CurrentSensor *sense_ic = new AnalogCurrentSensor(A1, 0.01);
    CurrentSensor *sense_ib = new AnalogCurrentSensor(A2, 0.01);
    VoltageSensor *sense_bus = new AnalogVoltageSensor(A5, 0.01);
    TempSensor *sense_t_motor = new TempSensor();
    TempSensor *sense_t_inverter = new TempSensor();
    Throttle *throttle = new Throttle(A0, 0.8f, 3.0f);
    
    PidController *pid_d = new PidController(0.001f, 0.1f, 0.0f, 1.0f, -1.0f);
    PidController *pid_q = new PidController (0.001f, 0.1f, 0.0f, 5.0f, -5.0f);
    
    Motor *motor = new Motor(sense_ic, sense_ib, sense_p, sense_t_motor);
    Inverter *inverter = new Inverter(D6, D13, D3, D8, sense_bus, sense_t_inverter);
    User *user = new User(throttle);
    Modulator *modulator = new SinusoidalModulator(inverter);
    StatusUpdater *updater = new StatusUpdater(inverter, motor, user);
    LoopDriver *driver = new LoopDriver(inverter, motor, user, pid_d, pid_q, modulator, 1.0f, 5000);
    
    motor->Config(4, 20.0f);
    updater->Config(5000, 100, 10);
         
    driver->Start();
    updater->Start();
}
