#include "includes.h"
#include "core.h"
#include "sensors.h"
#include "meta.h"
#include "lut.h"

unsigned long StatusUpdater::_time;

StatusUpdater::StatusUpdater(Inverter *inverter, Motor *motor, User *user) {
    _inverter = inverter;
    _motor = motor;
    _user = user;
    _fast_sample_rate = 5000;
    _med_sample_rate = 100;
    _slow_sample_rate = 10;
    
    _time_ticker.attach_us(&time_upd_isr, 50);
}

void StatusUpdater::Config(int fast_sample_rate, int med_sample_rate, int slow_sample_rate) {
    _fast_sample_rate = fast_sample_rate;
    _med_sample_rate = med_sample_rate;
    _slow_sample_rate = slow_sample_rate;
}

void StatusUpdater::time_upd_isr() {
    _time+= 50;
}

float StatusUpdater::LutSin(float theta) {
    if (theta < 0.0f) theta += 360.0f;
    if (theta >= 360.0f) theta -= 360.0f;
    return sinetab[(int) theta];
}

float StatusUpdater::LutCos(float theta) {
    return LutSin(90.0f - theta);
}

void StatusUpdater::Start() {
    _time = 0;
    int fast_us = 1000000 / _fast_sample_rate;
    int med_us = 1000000 / _med_sample_rate;
    int slow_us = 1000000 / _slow_sample_rate;
    
    int last_fast = 0;
    int last_med = 0;
    int last_slow = 0;
    
    for(;;) {
        if (_time - last_fast > fast_us) {
            
            _motor->UpdateState();
            _inverter->UpdateVbus();
            last_fast = _time;
            
            //pc->printf("%f %f %f %f %f\n\r", _motor->angle, _motor->I_c, _motor->I_b, test_alpha, test_beta);
            //pc->printf("%f %f %f\n\r", test_DtcA, test_DtcB, test_DtcC);
                                    
        }
        
        if (_time - last_med > med_us) {
                                       
        } 
        
        if (_time - last_slow > slow_us) {
            
            _user->UpdateState();
            _motor->UpdateTemp();
            _inverter->UpdateTemp();
            last_slow = _time;
            
            
            //pc->printf("%f %f\n\r", test_alpha, test_beta);
            
            /*
            for (int i = 0; i < 10000; i++) {
                pc.printf("%f,", fbuffer[i]);
            }
            */
           
                                  
            //pc->printf("%f %f\n\r", _inverter->va, _inverter->vb);
        }
    }
}