#include "includes.h"
#include "core.h"
#include "meta.h"
#include "sensors.h"
#include "lut.h"

void SinusoidalModulator::Update(float va, float vb) {
    _inverter->va = va;
    _inverter->vb = vb;
    
    //inverse \alpha \beta (Clarke) transform
    _inverter->SetDtcA(va);
    _inverter->SetDtcB(((-va + sqrt(3.0f)*vb)/2.0f));
    _inverter->SetDtcC(((-va - sqrt(3.0f)*vb)/2.0f));
    
    /*        
    test_alpha = va;
    test_beta = ((-va + sqrt(3.0f)*vb)/2.0f); 
    */
    
    /*
    _inverter->SetDtcA((LutSin(va)/2.0f)+0.5f);
    _inverter->SetDtcB((LutSin(va - 120.0f)/2.0f)+0.5f);
    _inverter->SetDtcC((LutSin(va + 120.0f)/2.0f)+0.5f);
    */
    
    test_DtcA = vb/2.0f + 0.5f;
    test_DtcB = ((-vb + sqrt(3.0f)*va)/2.0f)/2.0f + 0.5f;
    test_DtcC = ((-vb - sqrt(3.0f)*va)/2.0f)/2.0f + 0.5f;
    
    
    /*
    _inverter->SetDtcA(1.0f);
    _inverter->SetDtcB(0.5f);
    _inverter->SetDtcC(1.0f);
    */
}

float SinusoidalModulator::LutSin(float theta) {
    if (theta < 0.0f) theta += 360.0f;
    if (theta >= 360.0f) theta -= 360.0f;
    return sinetab[(int) theta] * 2.0f - 1.0f;
}

float SinusoidalModulator::LutCos(float theta) {
    return LutSin(90.0f - theta);
}