#include "includes.h"
#include "sensors.h"

AnalogCurrentSensor::AnalogCurrentSensor(PinName pin, float volts_per_amp) {
    _in = new AnalogIn(pin);
    _volts_per_amp = volts_per_amp;
    Zero();
}

void AnalogCurrentSensor::Zero() {
    float mean = 0;
    for(int i = 1; i<=1000; i++){
        mean = 0.1f*((float) *_in) + 0.9f*mean;
    }
    _zero_level = mean;
}

float AnalogCurrentSensor::GetCurrent() {
    return ((float) *_in - _zero_level) * 3.3f / _volts_per_amp;
}