#ifndef __CONFIG_H
#define __CONFIG_H

#define CPR 4096
#define POS_OFFSET 1.73f
#define POLE_PAIRS 3.0f
#define RESOLVER_LOBES 3.0f

#define PWMA PA_8
#define PWMB PA_9
#define PWMC PA_10
#define EN PB_15

#define IA PA_4
#define IB PB_0

#define I_SCALE_RAW 25.0f //mv/A
#define R_UP 12000.0f //ohms
#define R_DOWN 3600.0f //ohms
#define R_BIAS 3600.0f //ohms
#define AVDD 3300.0f //mV

#define I_OFFSET (AVDD * R_DOWN * R_UP / (R_DOWN * R_UP + R_BIAS * (R_DOWN + R_UP)))
#define I_SCALE (R_BIAS * R_DOWN * I_SCALE_RAW / (R_DOWN * R_UP + R_BIAS * (R_DOWN + R_UP)))

#define BUS_VOLTAGE 20.0f
#define K_LOOP 1.0f
#define KI_BASE 0.01f

#define KP (K_LOOP / BUS_VOLTAGE)
#define KI (KI_BASE * K_LOOP / BUS_VOLTAGE)

#define INTEGRAL_MAX 1.0f

#define set_dtc(phase, value) *phase = (value)
#define PI 3.141593f

#endif