#include "includes.h"
#include "core.h"
#include "sensors.h"

Inverter::Inverter(PinName ph_a, PinName ph_b, PinName ph_c, PinName en, VoltageSensor *sense_bus, TempSensor *sense_t) {
    _en = new DigitalOut(en);
    Disable();
    
    _pwm_a = new PwmOut(ph_a);
    _pwm_b = new PwmOut(ph_b);
    _pwm_c = new PwmOut(ph_c);
    _pwm_a->period_us(200);
    _pwm_b->period_us(200);
    _pwm_c->period_us(200);
    
    _sense_bus = sense_bus;
    _sense_t = sense_t;
    
    SetDtcA(0);
    SetDtcB(0);
    SetDtcC(0);
    
    TIM2->CR1 &= ~(TIM_CR1_CEN);
    TIM2->CR1 |= TIM_CR1_CMS;
    TIM2->CR1 |= TIM_CR1_CEN;
    
    Enable();
}

void Inverter::SetDtcA(float dtc) {
    if (dtc < 0) dtc = 0.0f;
    if (dtc > 1.0f) dtc = 1.0f;
    *_pwm_a = dtc;
} 

void Inverter::SetDtcB(float dtc) {
    if (dtc < 0) dtc = 0.0f;
    if (dtc > 1.0f) dtc = 1.0f;
    *_pwm_b = dtc;
} 

void Inverter::SetDtcC(float dtc) {
    if (dtc < 0) dtc = 0.0f;
    if (dtc > 1.0f) dtc = 1.0f;
    *_pwm_c = dtc;
}

void Inverter::Enable() {
    *_en = 1;
}

void Inverter::Disable() {
    *_en = 0;
}

float Inverter::GetVbus() {
    return _sense_bus->GetVoltage();
}

float Inverter::GetTemp() {
    return _sense_t->GetTemp();
}