#include "includes.h"
#include "meta.h"
#include "sensors.h"
#include "lut.h"
#include "core.h"

void SynchronousReferenceSynthesizer::GetReference(float angle, float throttle, float *ref_d, float *ref_q) {
    *ref_d = 0.00f;
    *ref_q = _max_phase_current * throttle;
}

float ReferenceSynthesizer::LutSin(float theta) {
    if (theta < 0.0f) theta += 360.0f;
    if (theta >= 360.0f) theta -= 360.0f;
    return sinetab[(int) theta] * 2.0f - 1.0f;
}

float ReferenceSynthesizer::LutCos(float theta) {
    return LutSin(90.0f - theta);
}