#include "includes.h"
#include "transforms.h"
#include "filters.h"
#include "context.h"
#include "core.h"
#include "meta.h"
#include "sensors.h"
#include "debug.h"

void fast(Context *c) {
    float alpha, beta, d, q, ref_d, ref_q, valpha, vbeta;
    float I_b, I_c, angle, d_filtered, q_filtered, vd, vq;
    dbg_ib = I_b = c->motor->GetCurrentB();
    dbg_ic = I_c = c->motor->GetCurrentC();
    dbg_angle = angle = c->motor->GetPosition();
    float speed_raw = c->motor->GetSpeed();
    dbg_speed = c->filter_sp->Update(speed_raw);
    
    Clarke(-(I_b + I_c), I_b, &alpha, &beta);
    Parke(alpha, beta, angle, &d, &q);
    dbg_q_raw = q;
    dbg_d_raw = d;
    
    dbg_d_filtered = d_filtered = c->filter_q->Update(q); //swapped  
    dbg_q_filtered = q_filtered = -c->filter_d->Update(d); //these and added a negative on this line. 
    
    //The necessary changes were analytically determined by observing that a postive vd command corresponded to a reading of negative q axis torque
    //and that a positive vq command produced a reading of positive d axis torque.  
    //This may be the final step in aligning the handedness of the reference and the output.
    
    c->user->UpdateThrottle();
    c->user->throttle = c->filter_th->Update(c->user->throttle);
    c->reference->GetReference(angle, c->user->throttle, &ref_d, &ref_q);
    
    dbg_ref_d = ref_d;
    dbg_ref_q = ref_q;
    dbg_loop_d = vd = c->pid_d->Update(ref_d, d_filtered);
    dbg_loop_q = vq = c->pid_q->Update(ref_q, q_filtered);

    dbg_throttle = c->user->throttle;
    
    if(c->user->throttle <= 0.05f){  //disable inverter - prevent whining, allow for safe precharge.
        c->inverter->Disable();
        c->pid_d->ZeroIntegrator();
        c->pid_q->ZeroIntegrator();
        }
    else {
        c->inverter->Enable();
    }
    
        
    dbg_loop_d = vd;
    dbg_loop_q = vq;
        
    InverseParke(vd, vq, angle, &valpha, &vbeta);
    
    dbg_valpha = valpha;
    dbg_vbeta = vbeta;
    
    c->modulator->Update(valpha, vbeta); 
}

void slow(Context *c) {
    //c->user->UpdateThrottle();
    //c->user->throttle = c->filter_th->Update(c->user->throttle);
}

void debug(Context *c) {
    //c->serial->printf("%f %f %f %f %f %f\n\r", dbg_d_filtered, dbg_q_filtered, dbg_ref_d, dbg_ref_q, dbg_loop_d, dbg_loop_q);
    //c->serial->printf("%f\n\r", dbg_angle);
    //c->serial->printf("%f\n\r", c->user->throttle);
    //c->serial->printf("%f %f\n\r", dbg_ib, dbg_ic);
}

void log(Context *c) {
    //c->debugger->Write(0, dbg_speed);
    //c->debugger->Write(1, dbg_q_filtered);
    //c->debugger->Write(2, dbg_d_filtered);
    //c->debugger->Write(3, dbg_angle);
}