#include <mbed.h>
#include "rtos.h"
#include "EthernetInterface.h"

DigitalOut gLinkLed(LED1);
Ethernet gLink;
EthernetInterface gEth;
volatile bool gbIsConnected = false;
volatile uint8_t gIsConnectedCount = 0;

void ThreadProcLinkCheck(void const *param)
{   bool bLink = false;
    bool bIp = false;
    
    while(1)
    {
        bLink = gLink.link();
        bIp = (gEth.getIPAddress() != NULL);
    
        if(!bLink || !bIp)
        {
            gbIsConnected = false;
            gIsConnectedCount = 0;
            if(bLink)
                gLinkLed = !gLinkLed;
            else
                gLinkLed = false;
        }
        else
        {
            gIsConnectedCount += (gIsConnectedCount < 10);
            if(gIsConnectedCount >= 10 && !gbIsConnected)
            {
                gbIsConnected = true;
                gLinkLed = true;
                printf("IP Address is %s\r\n", gEth.getIPAddress());
            }
        }
        Thread::wait(250);
    }
}

void ThreadProcSocket(void const *param)
{
    TCPSocketServer server;
    
    while(1)
    {   int rc;
    
        // wait for link
        printf("ThreadProcSocket:: waiting for link\r\n");
        while(!gbIsConnected)
            Thread::wait(250);

        rc = server.bind(80);
        printf("ThreadProcSocket:: bind server port %d\r\n",rc);
        if(rc == 0)
        {
            rc = server.listen(1);
            printf("ThreadProcSocket:: listen server port %d\r\n",rc);
            if(rc == 0)
            {
                TCPSocketConnection client;
                
                while(gbIsConnected)
                {   int rc = server.accept(client,1000);
                
                    printf("ThreadProcSocket:: accept %d\r\n",rc);
                    if(rc == 0)
                    {
                        printf("ThreadProcSocket:: client conection\r\n");
                        char str[] = "Hello... Goodbye.\r\n";
                        client.send_all(str, sizeof(str)-1);
                        printf("ThreadProcSocket:: client shutdown %d\r\n",client.shutdown(SHUT_RDWR));
                        printf("ThreadProcSocket:: client close %d\r\n",client.close());
                    }
                }
                client.close();
            }
            else
                printf("ThreadProcSocket:: Unable to listen on tcp socket\r\n");
        }
        else
            printf("ThreadProcSocket:: Unable to bind tcp socket\r\n");
            
        printf("ThradProcSocket:: shutdown server port\r\n");
        server.shutdown(SHUT_RDWR);
        printf("ThradProcSocket:: close server port\r\n");
        server.close();
    }
}

int main()
{
    printf("Boot - compiled %s %s\r\n",__DATE__,__TIME__);

    printf("Starting link check thread\r\n");    
    Thread linkCheck(&ThreadProcLinkCheck);
    
    printf("Starting tcp socket\r\n");
    Thread httpServer(&ThreadProcSocket);

    printf("Starting network\r\n");    
    gEth.init(); //Use DHCP
    gEth.connect();
    
    printf("Ready - main loop idle\r\n");
    while(1)
    {
        Thread::yield();
    }
}
