/*
 *  Copyright (C) 2012 Neal Horman - http://www.wanlink.com
 *
 *  Warranty;
 *      No warranty of fitness is given, express or implied,
 *      use at your own risk.
 *
 *  License;
 *      Use and modify as you wish as long as you keep this statement,
 *      the Warranty, and my Copyright above.
 *
 */
 
#ifndef _UDPBEACON_H_
#define _UDPBEACON_H_

#include "mbed.h"
#include "UDPSocket.h"
#include "NetService.h"

class Endpoint2 : public Endpoint
{
public:
    int set_address(uint32_t ip, const int port)
    {
        reset_address();

        _remoteHost.sin_addr.s_addr = htonl(ip);
        _remoteHost.sin_family = AF_INET;
        _remoteHost.sin_port = htons(port);

        return 0;
    }
};

class UDPSocket2 : public UDPSocket
{
public:
    int set_broadcast(bool bBroadcast = true)
    {   int val = bBroadcast;
    
        return lwip_setsockopt(_sock_fd,SOL_SOCKET,SO_BROADCAST,&val,sizeof(val));
    }
};

class UDPBeacon : public NetService
{
public:
    UDPBeacon(uint16_t port)
        : NetService()
        , mPort(port)
        , mTick(0)
        {};
    virtual bool Start();
    virtual void Poll();
    virtual void Stop();
protected:
       UDPSocket2 mServer;
       Endpoint2 mEndpoint;
       uint16_t mPort;
       time_t mTick;
};
#endif