/*
 *  Copyright (C) 2012 Neal Horman - http://www.wanlink.com
 *
 *  Warranty;
 *      No warranty of fitness is given, express or implied,
 *      use at your own risk.
 *
 *  License;
 *      Use and modify as you wish as long as you keep this statement,
 *      the Warranty, and my Copyright above.
 *
 */
 
#include "UDPBeacon.h"

bool UDPBeacon::Start()
{
    if(!mbRunning)
    {
        mbRunning = (
            mServer.bind(mPort) == 0
            && mServer.set_broadcast() == 0
            && mEndpoint.set_address(0xFFFFFFFF,mPort) == 0
            );
        if(mbRunning)
            mServer.set_blocking(false,10);
     }

    return mbRunning;
}

void UDPBeacon::Stop()
{
    if(mbRunning)
    {
        mbRunning = false;
        mServer.close();
    }
}

void UDPBeacon::Poll()
{
    if(mbRunning)
    {
        time_t timenow = time(NULL);
        if(timenow >= mTick)
        {
            mTick = timenow+1;
            
            mServer.sendTo(mEndpoint,"hello",5);
        }
    }
}