/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef UDPSOCKET_H
#define UDPSOCKET_H

#include "Socket/Socket.h"
#include "Socket/UDPPacket.h"
#include <cstdint>

/**
This is a C++ abstraction for UDP networking sockets.
*/
class UDPSocket : public Socket {

public:
    /** Instantiate a UDP Socket.
    */
    UDPSocket();
    
    ~UDPSocket();
    
    int init(void);
    
    /** Bind a UDP Server Socket to a specific port
    For a listening socket, bind the socket to the following port.
    \param port The port to listen for incoming connections on, using 0 here will select a random port.
    \return 0 on success, -1 on failure.
    */
    int bind(int port);
    
    /** Send a packet to the remote host.
    \param packet UDP Packet to be sent to the remote host
    \param timeout The maximum amount of time in ms to wait while trying to send the buffer.
    \return the number of written bytes on success (>=0) or -1 on failure
    */
    int sendTo(UDPPacket& packet, int timeout_ms=0);
    
    /** Receive data from a remote host.
    If a message is too long to fit in the supplied packet, excess bytes are
    discarded.
    \param packet UDP Packet received from the remote host
    \param timeout The maximum amount of time in ms to wait while trying to receive data.
    \return the number of received bytes on success (>=0) or -1 on failure
    */
    int receiveFrom(UDPPacket& packet, int timeout_ms=0);
};

#endif 
