/*
 *  Wiegand card reader driver library
 *  Copyright (c) 2012 Neal Horman - http://www.wanlink.com
 *  
 *  License: MIT open source (http://opensource.org/licenses/MIT)
 *      Summary;
 *      Use / modify / distribute / publish it how you want and 
 *      if you use it, or don't, you can't hold me liable for how
 *      it does or doesn't work.
 *      If it doesn't work how you want, don't use it, or change
 *      it so that it does work.
 */
 
 
#ifndef _READERWIEGAND_H_
#define _READERWIEGAND_H_

#include "Reader.h"

// Use interupt driven inputs to gather the card data
class ReaderWiegand : public Reader
{
public:
    ReaderWiegand(PinName data0, PinName data1) : Reader(), mData0Irq(data0), mData1Irq(data1)
    {
        mData0Irq.mode(PullUp);
        mData1Irq.mode(PullUp);
        mData0Irq.fall(this,&ReaderWiegand::data0Fall);
        mData1Irq.fall(this,&ReaderWiegand::data1Fall);
        mData0Irq.rise(this,&ReaderWiegand::data01Rise);
        mData1Irq.rise(this,&ReaderWiegand::data01Rise);
    };
protected:
    InterruptIn mData0Irq;
    InterruptIn mData1Irq;
    Timeout mTimer;
    void swiped() { Reader::swiped(); };
    
    void timerRestart() { mTimer.detach(); mTimer.attach_us(this,&ReaderWiegand::swiped,50*1000); };
    
    void data0Fall() { shiftIn(0); timerRestart(); };
    void data1Fall() { shiftIn(1); timerRestart(); };
    void data01Rise() { timerRestart(); };
};

#endif