/*
 *  Card / Proximity reader driver library
 *  Copyright (c) 2012 Neal Horman - http://www.wanlink.com
 *  
 *  License: MIT open source (http://opensource.org/licenses/MIT)
 *      Summary;
 *      Use / modify / distribute / publish it how you want and 
 *      if you use it, or don't, you can't hold me liable for how
 *      it does or doesn't work.
 *      If it doesn't work how you want, don't use it, or change
 *      it so that it does work.
 */

#ifndef _READER_H_
#define _READER_H_

class Reader
{
public:
    Reader()
        : mCard(0)
        , mFacility(0)
        , mSite(0)
        , mBits(0)
        , mBitsCount(0)
        , mbIsValid(false)
        , mbIsNew(false)
        , mbInhibited(false)
        {};
    
    uint32_t card() { return mCard; };
    uint32_t facility() { return mFacility; };
    uint16_t site() { return mSite; };
    bool isValid() { return mbIsValid; };
    bool isNew() { return mbIsNew; };
    void old() { mbIsNew = false; };
    
    bool isInhibited() { return mbInhibited; };
    void inhibit(bool bInhibit = true) { mbInhibited = bInhibit; };
    
    uint64_t bits() { return mLastBits; };
    uint8_t bitCount() { return mLastBitsCount; };

protected:
    volatile uint32_t mCard;
    volatile uint32_t mFacility;
    volatile uint16_t mSite;
    volatile uint64_t mLastBits;
    volatile uint8_t mLastBitsCount;
    
    volatile uint64_t mBits;
    volatile uint8_t mBitsCount;
    
    volatile bool mbIsValid;
    volatile bool mbIsNew;
    
    bool mbInhibited;

    void shiftIn(uint8_t bit)
    {
        if(bit)
            mBits |= ((uint64_t)1 << mBitsCount);
        mBitsCount ++;
    }
    
    uint32_t bits32(uint8_t first, uint8_t qty)
    {   uint32_t val = 0;
        uint8_t last = first + qty;
    
        for(uint8_t i=first; i<last; i++)
        {
            if(val)
                val <<= 1;
            if(mBits & (1<<i))
                val |= 1;
        }
        
        return val;
    }
    
    virtual bool decode()
    {   bool bIsValid = false;
        
        mSite = 0;
        if(mBitsCount == 26)
        {
            mFacility = bits32(1,8);
            mCard = bits32(9,16);
            bIsValid = true;
        }
        else if(mBitsCount == 34)
        {
            mFacility = bits32(1,16);
            mCard = bits32(17,16);
            bIsValid = true;
        }
        else if(mBitsCount == 35)
        {
            mFacility = bits32(2,12);
            mCard = bits32(14,20);
            bIsValid = true;
        }
        else
        {
            mFacility = 0;
            mCard = 0;
        }
        
        mLastBits = mBits;
        mLastBitsCount = mBitsCount;
        
        return bIsValid;
    }
    
    void swiped()
    {
        // decode mBits into mCard, mFacility, and mSite
        mbIsValid = !mbInhibited && decode();
        // reset mBits and mBitsCount for next operation
        mBits = 0;
        mBitsCount = 0;
        mbIsNew = !mbInhibited;
    };
};

#endif