#include "mbed.h"
#include "ltc2309.h"

    volatile unsigned int IKPa0[8];


I2C LTC2309(PB_9,PB_8);

// rem S/D O/S S1 S0 UNI SLP  tableau de config pour les 8 entrées
volatile char LTC2309config[] = {0b10001000,0b11001000,0b10011000,0b11011000,0b10101000,0b11101000,0b10111000,0b11111000};
// calcul pression a partir de autozero
float pression(unsigned int IKPa, unsigned int IKPa_0)
{
    float IKPai = IKPa;       // AutoZéro
    float IKPa_0i = IKPa_0;   // Pression lue en temps réél 
    return (IKPai-IKPa_0i);   // AutoZéro - Pression lue en temps réél = Valeur en Pascal
    }

// Pour recuperer la valeur de la première case LTC2309config[0];
void LTC2309Init(void)
{
    LTC2309.frequency(LTC2309Frequence);
}
void LTC2309Autozero(void)
{
    // mesure a vide soufflerie arretee    
    IKPa0[0] = LTC2309read(CH0c);       // AutoZéro de l'entrée 0
    IKPa0[1] = LTC2309read(CH1c);       // AutoZéro de l'entrée 1
    IKPa0[2] = LTC2309read(CH2c);       // AutoZéro de l'entrée 2
    IKPa0[3] = LTC2309read(CH3c);       // AutoZéro de l'entrée 3
    IKPa0[4] = LTC2309read(CH4c);       // AutoZéro de l'entrée 4
    IKPa0[5] = LTC2309read(CH5c);       // AutoZéro de l'entrée 5
    IKPa0[6] = LTC2309read(CH6c);       // AutoZéro de l'entrée 6
    IKPa0[7] = LTC2309read(CH7c);       // AutoZéro de l'entrée 7
    }
// entree 0 a 7....
float LTC2309read(unsigned NumEntree)
{
    LTC2309.start();
    LTC2309.write(LTC2309Adresse); // adresse + r/w = 0 en lecture
    LTC2309.write(LTC2309config[NumEntree]); // mot de config de l'entre
    LTC2309.stop();
    LTC2309.start();
    LTC2309.write((LTC2309Adresse+1)); // r/w a 1 pour lectur
    unsigned a = LTC2309.read(1) * 16 + LTC2309.read(1)/16; // decale a droite de 4 bit.
    LTC2309.stop();
    return pression(a,IKPa0[NumEntree]);
}