#include "mbed.h"
#include "rtos.h"
#include "Motor.h"
#include "uLCD_4DGL.h"

RawSerial  pi(USBTX, USBRX);

Thread thread_drink_1;
Thread thread_drink_2;
Thread thread_drink_3;
Thread thread_drink_4;
Thread thread_drink_5;
Thread thread_drink_6;
//Thread thread_play_song;
//Thread thread_display_led;

Motor drink1(p21, p5, p6); //pwd, rev, fwd
Motor drink2(p22, p7, p8); //pwd, rev, fwd
Motor drink3(p23, p9, p10); //pwd, rev, fwd
Motor drink4(p24, p11, p12); //pwd, rev, fwd
Motor drink5(p25, p13, p14); //pwd, rev, fwd
Motor drink6(p26, p15, p16); //pwd, rev, fwd

bool run1 = false;
bool run2 = false;
bool run3 = false;
bool run4 = false;
bool run5 = false;
bool run6 = false;


int oz1 = 0;
int oz2 = 0;
int oz3 = 0;
int oz4 = 0;
int oz5 = 0;
int oz6 = 0;

char drinkName [128];

// debug shit
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;

int sec_per_oz = 9000; //msec


 
void drink1_thread() {
    while (true) {
        if (run1) {
            led1 = 1;
            drink1.speed(-1.0);
            Thread::wait(sec_per_oz * oz1);
            drink1.speed(0.0);
            led1 = 0;
            run1 = false;
        }
    }
}

void drink2_thread() {
    while (true) {
        if (run2) {
            led2 = 1;
            drink2.speed(-1.0);
            Thread::wait(sec_per_oz * oz2);
            drink2.speed(0.0);
            led2 = 0;
            run2 = false;
        }
    }
}
 
 void drink3_thread() {
    while (true) {
        if (run3) {
            led3 = 1;
            drink3.speed(1.0);
            Thread::wait(sec_per_oz * oz3);
            drink3.speed(0.0);
            led3 = 0;
            run3 = false;
        }
    }
}
 
 
 void drink4_thread() {
    while (true) {
        if (run4) {
            led4 = 1;
            drink4.speed(-1.0);
            Thread::wait(sec_per_oz * oz4);
            drink4.speed(0.0);
            led4 = 0;
            run4 = false;
        }
    }
}
 
 
 void drink5_thread() {
    while (true) {
        if (run5) {
            drink5.speed(1.0);
            Thread::wait(sec_per_oz * oz5);
            drink5.speed(0.0);
            run5 = false;
        }
    }
}
 
 
void drink6_thread() {
    while (true) {
        if (run6) {
            drink6.speed(1.0);
            Thread::wait(sec_per_oz * oz6);
            drink6.speed(0.0);
            run6 = false;
        }
    }
}
 
void dev_recv()
{
    char temp = 0;
    char motorVal = 0;
    int indexVal = 0;
    int ounceNum = 0;
    while(pi.readable()) {
        temp = pi.getc();
        if (temp == '!') {
            ounceNum = 0;
            indexVal = 0;
            temp = pi.getc();
            while (temp != '{') {
                drinkName[indexVal] = temp;
                indexVal++;
                temp = pi.getc();
            }
            drinkName[indexVal] = 0; // null character
            pi.printf("%s\n",drinkName);
            motorVal = pi.getc(); // get motor Value
            while (temp != '}') {
                temp = pi.getc(); // colon
                temp = pi.getc(); // first digit of drink
                ounceNum = 0;
                while (temp != ',') { // get how many ounces
                    ounceNum = ounceNum * 10;
                    ounceNum = ounceNum + (int)(temp - '0');
                    temp = pi.getc();
                }
                if (ounceNum > 0) {
                    switch(motorVal) {
                        case '1':
                            oz1 = ounceNum;
                            run1 = true;
                            break;
                        case '2':
                            oz2 = ounceNum;
                            run2 = true;
                            break;
                        case '3':
                            oz3 = ounceNum;
                            run3 = true;
                            break;
                        case '4':
                            oz4 = ounceNum;
                            run4 = true;
                            break;
                        case '5':
                            oz5 = ounceNum;
                            run5 = true;
                            break;
                        case '6':
                            oz6 = ounceNum;
                            run6 = true;
                            break;
                        default:
                            break;
                    }
                }    
                temp = pi.getc();      
                if (temp != ',') {
                    motorVal = temp;
                }        
            } 
        }
    }
}
int main() {
    thread_drink_1.start(drink1_thread);
    thread_drink_2.start(drink2_thread);
    thread_drink_3.start(drink3_thread);
    thread_drink_4.start(drink4_thread);
    thread_drink_5.start(drink5_thread);
    thread_drink_6.start(drink6_thread);
    //thread_play_song.start();
    //thread_display_led.start();
    uLCD.cls();
    uLCD.text_width(2); //4X size text
    uLCD.text_height(2);
    uLCD.printf("DrinkBot\n  4000");
    pi.baud(9600);
    pi.attach(&dev_recv, Serial::RxIrq);
    while(1) {
        sleep();
    }
}
