#include "mbed.h"
#include "MODSERIAL.h"   
#include "UM6_usart.h"     // UM6 USART HEADER
#include "UM6_config.h"    // UM6 CONFIG HEADER
#include "GPS.h"

//------------ system and interface setup ----------------------------//
Serial pc(USBTX, USBRX);  // sets up serial connection to pc terminal

//------------ Hardware setup ----------------------------------------//
DigitalOut pc_led(LED1);               // LED1 = PC SERIAL
DigitalOut uart_led(LED2);             // LED2 = UM6 SERIAL
GPS gps(NC,p27); 


// interupt function for processing uart messages --------------------// 
void rxCallback(MODSERIAL_IRQ_INFO *q) {
    if (um6_uart.rxBufferGetCount() >=  MAX_PACKET_DATA) {
        uart_led = !uart_led;  // Lights LED when uart RxBuff has > 40 bytes
        Process_um6_packet();
    }
}


//============= Main Program =========================================//
int main() {    
    Timer t;
    GPS_Time q1;
    GPS_VTG  v1;
    int Roll_Counter=0;
    
    pc.baud(115200);       // baud rate to pc interface
    um6_uart.baud(115200); // baud rate to um6 interface
    gps.baud(115200);
    gps.format(8, GPS::None, 1);
    
    //---- call interrupt functions --------------------------//
    um6_uart.attach(&rxCallback, MODSERIAL::RxIrq); // attach interupt function to uart
    t.start(); // start logging timer    
    
    //---- main while loop -------------------------------------------// 
    while(1) {                               
          Roll_Counter++;      
         if (Roll_Counter > 10000000) {

          gps.vtg(&v1); 

          pc.printf("time %f s, Yaw %f deg, speed %f, longitude %f \n ",t.read(),data.Yaw,v1.velocity_kph(),gps.longitude());
          pc_led = !pc_led; 
          Roll_Counter = 0;
         }         
                             
    } // end while(1) loop
 
} // end main() program
