#include "mbed.h"          // MBED LIBRARY
#include "MODSERIAL.h"     // MBED BUFFERED SERIAL

#include "UM6_usart.h"     // UM6 USART HEADER
#include "UM6_config.h"    // UM6 CONFIG HEADER

LocalFileSystem local("local");               // Create local filesystem under the name "local"

/////////////////////////////////////////////////////////////////////////////////////////////
// SETUP (ASSIGN) SERIAL COMMUNICATION PINS ON MBED
/////////////////////////////////////////////////////////////////////////////////////////////
MODSERIAL pc(USBTX, USBRX);  // PC SERIAL OVER USB PORT ON MBED

////////////////////////////////////////////////////////////////////////////////////////////////
// SETUP (ASSIGN) MBED LED (1 thru 3) FOR VISUAL DEBUGGING ON MBED
////////////////////////////////////////////////////////////////////////////////////////////////
DigitalOut pc_activity(LED1);    // LED1 = PC SERIAL
DigitalOut uart_activity(LED2);  // LED2 = UM6 SERIAL
DigitalOut logLED(LED3);  // LED3 = logging active
DigitalOut sync(p6);
DigitalIn enable(p5);    // enable signal for logging data to file

Timer t; // sets up timer for measuring data time stamp
Timer t1;// sets up timer for measuring time to read/write data

void rxCallback(MODSERIAL_IRQ_INFO *q) {
    if (um6_uart.rxBufferGetCount() >=  MAX_PACKET_DATA) {
        uart_activity = !uart_activity;  // Lights LED when uart RxBuff has > 40 bytes
        Process_um6_packet();
    }
}


int main() {


/////////////////////////////////////////////////////////////////////////////////////////////////////
//          SET SERIAL UART BAUD RATES
/////////////////////////////////////////////////////////////////////////////////////////////////////

    // set UM6 serial uart baud rate
    um6_uart.baud(115200); // baud rate to um6 interface
    pc.baud(115200);  // baud rate to pc interface
    
    // attach interupt function to uart
    um6_uart.attach(&rxCallback, MODSERIAL::RxIrq);

    // opens file for saving data to and sets up header row

    FILE *fp = fopen("/local/out3.csv", "w");  // Open "out.txt" on the local file system for writing
    fprintf(fp, "time (s),Yaw (deg),Roll (deg),Pitch (deg),GyroX,GyroY,GyroZ,AccelX,AccelY,AccelZ,GPScourse(x100 deg),GPSspeed(x100 m/s)\r");   // sends header to file
 
    t.start(); // start data log time
    sync = 1;
    while (enable) {
         logLED = 1; // turns LED3 on when logging starts
         wait(0.02);                
           float time1=t.read();
           float Yaw=data.Yaw;
           float Roll=data.Roll;
           float Pitch=data.Pitch;
           float GyroX=data.Gyro_Proc_X;
           float GyroY=data.Gyro_Proc_Y;
           float GyroZ=data.Gyro_Proc_Z;
           float AccelX=data.Accel_Proc_X;
           float AccelY=data.Accel_Proc_Y;
           float AccelZ=data.Accel_Proc_Z;
           float GPSlong=data.GPS_long;        // currently I can get GPS longitude to out data
           float GPSlat=data.GPS_lat;          // currently I can get GPS latitude to out data
           float GPScourse=data.GPS_course;
           float GPSspeed=data.GPS_speed;
           
         // print to file every 20ms - this is what I would idealy do but it ends up freezing on a single value        
         fprintf(fp, "%3.3f, %3.1f,%3.1f,%3.1f, %4.1f,%4.1f,%4.1f, %1.3f,%1.3f,%1.3f, %4.0f,%f\n",time1,Yaw,Roll,Pitch,GyroX,GyroY,GyroZ,AccelX,AccelY,AccelZ,GPScourse,GPSspeed);
         
         // print to screen - I use this to check that data is outputting - works fine on its own, but also freezes when above line is used
         pc.printf("time %3.3f, yaw %3.1e,%3.1e,%3.1e, gyro %4.1e,%4.1e,%4.1e,accel %1.3e,%1.3e,%1.3e,speed %4.0e, course %5.0e\n",time1,Yaw,Roll,Pitch,GyroX,GyroY,GyroZ,AccelX,AccelY,AccelZ,GPScourse,GPSspeed);
         
         pc_activity = !pc_activity;  // Lights LED1 when uart RxBuff has > 40 bytes         
                
    }  // end while(1) loop
   fprintf(fp,"%3.3f \n",t.read());  // records time at end of measurement
   sync = 0;    // zeros synchronization digital output
   wait(0.6);  // debug - hold LED on for 0.6s, even when while loop not true
   logLED = 0;  // turns LED3 off when logging ends
   fclose(fp);  // closes log file, otherwise cannot access mbed drive

}  // end main()