#include "mbed.h"
#include "SDFileSystem.h"    // SD file system header from handbook/cookbook offical mbed library
#include "MODSERIAL.h"   
#include "UM6_usart.h"     // UM6 USART HEADER
#include "UM6_config.h"    // UM6 CONFIG HEADER
#include "GPS.h"

//------------ system and interface setup ----------------------------//
MODSERIAL pc(USBTX, USBRX);  // sets up serial connection to pc terminal

//------------ Hardware setup ----------------------------------------//
DigitalOut pc_led(LED1);               // LED1 = PC SERIAL
DigitalOut uart_led(LED2);             // LED2 = UM6 SERIAL
DigitalOut log_led(LED3);              // debug LED
DigitalOut debug_led(LED4);            // debug LED
DigitalIn enable(p10);                 // enable logging pin
DigitalOut sync(p17);                  // sychronization (with CAN logger) pin  
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
GPS gps(NC,p27); 
Timer t_debug;
int counter;

// interupt function for processing uart messages --------------------//
int flag_uart=0;
float time_debug;
void rxCallback(MODSERIAL_IRQ_INFO *q) {
  if (um6_uart.rxBufferGetCount() >=  MAX_PACKET_DATA) {                   
        uart_led = 1;  // Lights LED when uart RxBuff has > 40 bytes
                    t_debug.start();
        Process_um6_packet();
           t_debug.stop();
           time_debug=t_debug.read();
           t_debug.reset();
        uart_led = 0;
        counter++;
  }    
}

//------------ LogData interrupt function ----------------------------//
int flag_log=0;
void LogData() {
            flag_log=1;     //interrupt sets flag that causes variables to be logged
}
//------------ Pc print interrupt function ----------------------------//
// to print to PC a a different rate to logging
int flag_pc=0;
void pcData() {
            flag_pc=1;     //interrupt sets flag that causes variables to be logged
} 

//============= Main Program =========================================//
int main() {
    Ticker tick;         
    Ticker tick1;         
    Timer t;
    sync = 0;
    GPS_Time q1;
    GPS_VTG  v1;
    
    pc.baud(115200);       // baud rate to pc interface
    um6_uart.baud(115200); // baud rate to um6 interface
    gps.baud(115200);
    gps.format(8, GPS::None, 1);
    
    //---- call interrupt functions --------------------------//
    um6_uart.attach(&rxCallback, MODSERIAL::RxIrq); // attach interupt function to uart
    tick.attach(&LogData, 1); // attaches LogData function to 'tick' ticker interrupt every 0.5s
    tick1.attach(&pcData, 0.5); // attaches LogData function to 'tick' ticker interrupt every 0.5s

    //---------- setup sd card directory------------------------------// 
    int FileNo = 0;
    mkdir("/sd/log_data", 0777);  

    //---- main while loop -------------------------------------------// 
    while(1) {            
            //---- Setup file on SD card ----------------------------//
            printf("Opening sd card\n");           
            char buffer[50];
            sprintf(buffer, "/sd/log_data/%i.csv", FileNo);
            //****************************************************
            // This is necessary for card to work when reconnected
            // Initialise disk
            sd.disk_initialize();
            //****************************************************
            // Open a file for write
            FILE *fp = fopen(buffer, "w"); 
            if(fp == NULL) {
                error("Could not open file for write\n");
            }
            //--- print ALL signals headers to sd card
            fprintf(fp, "time(s),Yaw(deg),Roll(deg),Pitch(deg),GyroX(deg/s),GyroY(deg/s),GyroZ(deg/s),AccelX(g),AccelY(g),AccelZ(g),GPScourse(deg),GPSspeed(km/h),Latitude(deg),Longitude(deg) \r");   // sends header to file
            
            // start time
            gps.timeNow(&q1);
            pc.printf("%c %02d:%02d:%02d %02d/%02d/%04d\r\n",
                      q1.status, q1.hour, q1.minute, q1.second, q1.day, q1.month, q1.year);
           // printf("%c %02d:%02d:%02d %02d/%02d/%04d\r\n",
           //           q1.status, q1.hour, q1.minute, q1.second, q1.day, q1.month, q1.year);    
            t.start(); // start logging timer        
            sync = 1;  // sync step sent to VN8900
                      
            while (!pc.readable() && enable) {  
                    if(flag_log==1) {  
                        log_led= !log_led;  // turns on LED3 to indicate logging   
                        float time=t.read();
                        float Yaw=data.Yaw;
                        float Roll=data.Roll;
                        float Pitch=data.Pitch;
                        float GyroX=data.Gyro_Proc_X;
                        float GyroY=data.Gyro_Proc_Y;
                        float GyroZ=data.Gyro_Proc_Z;
                        float AccelX=data.Accel_Proc_X;
                        float AccelY=data.Accel_Proc_Y;
                        float AccelZ=data.Accel_Proc_Z;
         /*               double GPSlong=gps.longitude();        // currently not reading GPS longitude correctly
                        double GPSlat=gps.latitude();                   // currently not reading GPS latitude correctly
                        double GPSalt=gps.altitude(); 
                        gps.vtg(&v1);
                        float GPScourse=v1.track_true();
                        float GPSspeed=v1.velocity_kph();
        */

                        //----- print ALL signals to file --------------------//  
          //              fprintf(fp, "%3.3f, %3.1f,%3.1f,%3.1f, %3.2f,%3.2f,%3.2f, %3.4f,%3.4f,%3.4f, %3.1f,%3.2f, %f,%f,%f\r",
          //                          time, Yaw,Roll,Pitch, GyroX,GyroY,GyroZ, AccelX,AccelY,AccelZ, GPScourse,GPSspeed, GPSlat,GPSlong,GPSalt);                             
                        flag_log=0; // reset LogData interrupt flag                                                                                           
                    }    // end if(flag=1) loop
                  
                    if(flag_pc==1) {
                        float time=t.read();
                        float Yaw=data.Yaw;             
                        float AccelX=data.Accel_Proc_X;
                        float AccelY=data.Accel_Proc_Y;
                        float AccelZ=data.Accel_Proc_Z;
                        double GPSlong=gps.longitude();        // currently not reading GPS longitude correctly
                        double GPSlat=gps.latitude();                   // currently not reading GPS latitude correctly
                        gps.vtg(&v1);
                        float GPScourse=v1.track_true();
                        float GPSspeed=v1.velocity_kph();
                                    
                         pc.printf("time %.3f,Yaw %3.0f,Accel %.2f, Lat %f, Long %f, kph %.lf \n",
                                     time,Yaw,AccelX,GPSlat,GPSlong,GPSspeed);   
            pc.printf("debug time %f, counter %d \n", time_debug, counter);
            counter = 0;
            //              pc.printf("time %.3f,Yaw %3.0f,Accel %.2f \n",
            //                         time,Yaw,AccelX);                                                                                                     
                        flag_pc=0;
                        pc_led = !pc_led;  // Lights LED1 when transmitting to PC screen   
                    }  

            } // end while(!pc.readable()) loop            
            sync = 0;  // sync step end sent to VN900
            fprintf(fp,"sync time %f \n",t.read());
            pc.printf(" Done. \n");     // prints 'done when logging is finished/enable switched off
            log_led=0;                  // turns off LED logging is finished/enable switched off
            wait(0.5);                  // debug wait for pc.printf      
            fclose(fp);                 // closes log file
            pc.getc();                  // Clear character from buffer            
            
            while (!pc.readable() && !enable) {  // Wait for a key press to restart logging
            };
            pc.getc();            // Clear character from buffer
            FileNo++;             // Increment file number     
    } // end while(1) loop
 
} // end main() program


/* DEUBBING NOTES
-----------------------------------------------------------------------------------------------
   opening a file BEFORE calling interrupts                         OK
   opening a file and print to it BEFORE calling interrupts         NOT OK (stops rest of program)
   open a (local) file and print to it AFTER calling interrupts     NOT OK (stops rest of program)
   open a (sd) file and print to it AFTER calling interrupts        OK 
-----------------------------------------------------------------------------------------------
measuring processor time for code
    defining all of data variables including gps speed and course = 8us
    printing all data to sd card = 250us - upto 25ms periodically
    printing select data to pc = 400-500us
    
-----------------------------------------------------------------------------------------------

*/