#include "mbed.h"
#include "MFRC522.h"

// FRDM-K64F (Freescale) Pin for MFRC522 reset
#define MF_RESET    PTD0

// Defining the serial ports for PC and Bluetooth
#define SERIAL_1  
Serial pc(USBTX, USBRX);
#ifdef SERIAL_1
Serial blue(PTC15,PTC14);         
#endif
#ifdef SERIAL_2
Serial blue(PTC17,PTC16);         // TX = P14  RX = P13
#endif

DigitalOut LedGreen(LED2), LedRed(LED1);

Timer timeBetweenCards;
char tagname;
char * cardtypetest;
char cardid;

//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
MFRC522    RfChip   (PTD2, PTD3, PTD1, PTE25, PTD0);

int main(void) {
  
  blue.baud(9600);
  pc.baud(9600);
  LedRed= 0;
  pc.printf("RFID based Alert System Started\r\n");
  printf("-------------------------------------------------------------\r\n");

  // Init. RC522 Chip
  RfChip.PCD_Init();

  while (true) {

    tagname = '\0';
    LedRed= 1;
    LedGreen = 1;

    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(100);
      continue;
    }

    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(100);
      
      continue;
      
    }
    
    // When a card is detected, a Green Led flashes!
    blue.printf("%f seconds \n", timeBetweenCards.read());
    timeBetweenCards.start();
    LedGreen = 0; 
    
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
  //    printf(" %X02", RfChip.uid.uidByte[i]);
        cardid= RfChip.uid.uidByte[i];
        blue.printf(" %X02 ", (char *) cardid);
        tagname= RfChip.uid.uidByte[i]+ tagname;
        blue.putc(tagname);
     }
    printf("\n\r");
    if (tagname == 206) {
        
        printf ("Blue Keychain detected: Welcome, Nivedita!");
        printf("\n\r");
        printf("------------------------------------------------");
        
        }
    else if (tagname == 124) {
        printf ("White Card detected: Welcome, Apoorva!");
        printf("\n\r");
        printf("------------------------------------------------");        
        }
    else if (tagname == 76) {
        printf ("Unknown person (White card): sending alert!! ");
        printf("\n\r");
        printf("------------------------------------------------");        
        }
      else if (tagname == 58) {
        printf ("Unknown person (Blue keychain): sending alert!! ");
        printf("\n\r");
        printf("------------------------------------------------");        
        }
        else {
        printf("--------------------!!!!!!!!!---------------------\n\r");    
        printf("Unknown card/keychain detected; sending alert!!!");
        printf("\n\r");
        printf("------------------------------------------------");        
        }
               
    // Print Card UID
    printf("\n\r");
    printf("Card UID: ");
    
   for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
        printf(" %X02", RfChip.uid.uidByte[i]);
        cardid= RfChip.uid.uidByte[i];
        blue.printf(" %X02 ", (char *) cardid);
        tagname= RfChip.uid.uidByte[i]+ tagname;
        blue.putc(tagname);
    }
    printf("\n\r");
              
    printf("Decimal tagname:  %d \n\r", tagname);   
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    cardtypetest= RfChip.PICC_GetTypeName(piccType);
    blue.printf("PICC Type: %s \n\r",(char *) cardtypetest);
    printf("________________________________________________");
    //wait_ms(100);
  }
}