#include "mbed.h"
#include "WaveFileReader.h"
#include "USBHostMSD.h"
#include "CircularBuffer.h"

#define MAXSIZE 4096
#define EXTRASIZE 0

Serial pc(USBTX,USBRX);

unsigned short buffer[MAXSIZE];
AnalogOut DACout(p18);
Ticker ticker;
//CircularBuffer<unsigned short> circularBuffer(MAXSIZE+EXTRASIZE);  

void writeAnalog(){
    static int i=0;
    if(i>=1024)i = 0;
    //DACout.write_u16(circularBuffer.readOneSample());
    DACout.write_u16(buffer[i]);
    i++;
    
}

int main() {
         
    pc.printf("\r\n Detecting USB...");
    fflush(stdout);
    
    USBHostMSD msd("usb");
    while(!msd.connect()) {
        Thread::wait(500);
        pc.printf("\r\nwaiting..");
    }
    pc.printf("\r\n USD Detected");
    fflush(stdout);
     
    FILE *file;
    file = fopen("/usb/sample.wav","r");
    WaveFileReader waveReader(file,false);
    pc.printf("\r\n File opened");
    fflush(stdout);
    
    float samplePeriod = waveReader.readSamplePeriod();
    waveReader.read(buffer,MAXSIZE);   
    ticker.attach_us(&writeAnalog,samplePeriod);
    //pc.printf("\r\n Ticker attached");
    
 //   while(1){
//        while(circularBuffer.writeSizeRemaining() < MAXSIZE){}
//        //pc.printf("\r\n Reading next MAXSIZE");
//        //fflush(stdout);
//        int length = waveReader.read(buffer,MAXSIZE);  
//        if(length<MAXSIZE){
//            circularBuffer.write(buffer,MAXSIZE); 
//            break;
//        }
//        //Mixer.mix(buf);
//        circularBuffer.write(buffer,MAXSIZE); 
//    }
    fclose(file);
    while(1) {
         
    }
}