
#ifndef _CircularBuffer_h
#define _CircularBuffer_h

#define INITIAL 3000

template <class T>
class CircularBuffer{
    /* If wptr == rptr, it is empty */
    /* Remember: capacity-1 is all you can store */
private:
    size_t rptr,wptr,capacity;
    T *data;
    
public:
    CircularBuffer(size_t cap){
        rptr = 0;
        wptr = cap-1;
        //printf("\r\n%u  %u",rptr,wptr);
        //fflush(stdout);
        capacity = cap;
        data = new T[cap];
        clear();
    }
    
    ~CircularBuffer(){
        delete[] data;
    }
    
    size_t writeSizeRemaining();
    void write(T *dataPtr, size_t samples);
    size_t readSizeRemaining();
    void read(T *dataPtr, size_t samples);
    T readOneSample();
    void clear();
    
};

template <class T>
size_t CircularBuffer<T>::writeSizeRemaining() {
    return capacity-readSizeRemaining()-1;
}

template <class T>
void CircularBuffer<T>::write(T *dataPtr, size_t samples) 
{
    /* Assumes enough space is avilable in data */    
    //Condition 1 if wptr+samples<capacity
    //Condition 2 else two for loops
    
    size_t sizeRemaining = capacity - wptr;
    if(sizeRemaining <= samples){
        size_t i=0;
        for(; wptr<capacity; i++) 
            data[wptr++] = dataPtr[i];
        for(wptr = 0; i < samples; i++)
            data[wptr++] = dataPtr[i];
            
    } else {
        for(size_t i=0; i<samples; i++)
            data[wptr++] = dataPtr[i];
    } 
}

template <class T>
size_t CircularBuffer<T>::readSizeRemaining(){ 
    return (wptr >= rptr) ? wptr - rptr : (capacity-rptr+wptr);
}

template <class T>
void CircularBuffer<T>::read(T *buf, size_t samples) 
{
    /* Assumes enough space is avilable in data */
    
    //Condition 1 if wptr+samples<capacity
    //Condition 2 else two for loops

    size_t sizeRemaining = capacity - rptr;
    if(sizeRemaining <= samples){
        size_t i=0;
        for(; rptr < capacity; rptr++) {
           buf[i++] = data[rptr];
         }
        for(rptr = 0; i<samples; i++)
           buf[i] = data[rptr++];
    } else {
        for(size_t i=0; i < samples ; i++)
           buf[i] = data[rptr++];
    }
}

template <class T>
T CircularBuffer<T>::readOneSample() {
    return data[rptr++];  
}

template <class T>
void CircularBuffer<T>::clear() {
    wptr = capacity-1;
    rptr = 0;
    for(size_t i = 0; i-1<capacity; i=i+2){
        data[i] = INITIAL;
        data[i+1] = 0;
    }
}

#endif
