#include "AudioObj.h"
//#include <iostream>

Location AudioObj::getLocation () const {
    return this->location;
}

void AudioObj::setLocation (const Location& loc) {
    this->location = loc;
}

void AudioObj::setLocation (float x, float y, float z) {
    this->location = Location(x,y,z);
}

Velocity AudioObj::getVelocity () const {
    return this->velocity;
}

void AudioObj::setVelocity (const Velocity& vel) {
    this->velocity = vel;
}

void AudioObj::setVelocity (float dx, float dy, float dz) {
    this->velocity = Velocity(dx,dy,dz);
}

float AudioObj::getVolume() const {
    return this->volume;
}

void AudioObj::setVolume(float vol) {
    if (vol > 1 || vol < 0){
        std::cout<<"Volume not in range (0-1)"<<endl;
        //throw invalid_argument("Volume not in range (0-1)");
    }
    this->volume = vol;
}

void AudioObj::setRandomVolume() {
    float randVol = (rand() % 100 + 1) / 100.0;
	this->setVolume(randVol);
}
	
bool AudioObj::isActive() const {
    return this->active;
}

void AudioObj::setActive(bool active){
    this->active = active;
}

bool AudioObj::isGpsObject() const {
    return this->gpsObject;
}

bool AudioObj::isBackgroundObject() const {
    return this->backgroundObject;
}

void AudioObj::setRepeat(bool rep) {
    this->repeat = rep;
}


bool AudioObj::fillAudioData (Complex* target, unsigned int length) {
    if(circularBuffer.readSizeRemaining() < length) {
                return false;
    }
    circularBuffer.read(target, length);
    return true;
}

void AudioObj::loadCircularBuffer() {
    unsigned int length = (unsigned int)circularBuffer.writeSizeRemaining();
    if(length>16384) { // TODO: How was this number chosen???
        //cout<<"In write circ Buff : "<<length<<endl;
        if(!(wavObject.loadMoreData(length, repeat))) {
            // end of file reached, no repeat
            this->active = false;
            this->isCompleted = true;
            return;
        }
        circularBuffer.write(wavObject.complexTempData, length);
    }
}

void AudioObj::playOnceFromBeginning() {
    this->repeat = false;
    this->restart();
}

void AudioObj::restart() {
    this->circularBuffer.clear();
    this->wavObject.seekToBeginning();
    this->loadCircularBuffer();
    this->active = true;
}

void AudioObj::loadFromBeginning() {
    this->circularBuffer.clear();
    this->wavObject.seekToBeginning();
    this->loadCircularBuffer();
    this->active = false;
}
