# memap - Static Memory Map Analysis

## Introduction

*memap* is a simple utility that displays static memory information required by [mbed](https://github.com/mbedmicro/mbed) applications. This information is produced by analysing the memory map file previously generated by your toolchain.

**Note**: this tool shows static RAM usage and the total size of allocated heap and stack space defined at compile time, not the actual heap and stack usage (which may be different depending on your application).

## Table of contents

1. [Using memap](#using-memap)
1. [Information on memory sections](#info-mem-sections)
1. [Current support](#current-support)
1. [Known problems](#known-problems)

## Using memap

*memap* is automatically invoked after an mbed build finishes successfully. It's also possible to manually run the program with different command line options, for example:

```
$> python memap.py
usage: memap.py [-h] -t TOOLCHAIN [-o OUTPUT] [-e EXPORT] [-v] file

Memory Map File Analyser for ARM mbed version 0.3.11

positional arguments:
  file                  memory map file

optional arguments:
  -h, --help            show this help message and exit
  -t TOOLCHAIN, --toolchain TOOLCHAIN
                        select a toolchain used to build the memory map file
                        (ARM, GCC_ARM, IAR)
  -o OUTPUT, --output OUTPUT
                        output file name
  -e EXPORT, --export EXPORT
                        export format (examples: 'json', 'csv-ci', 'table':
                        default)
  -v, --version         show program's version number and exit
```

Result example:

```
$> python memap.py GCC_ARM\myprog3.map -t GCC_ARM

+----------------------------+-------+-------+------+
| Module                     | .text | .data | .bss |
+----------------------------+-------+-------+------+
| Fill                       |   170 |     0 | 2294 |
| Misc                       | 36282 |  2220 | 2152 |
| core/hal                   | 15396 |    16 |  568 |
| core/rtos                  |  6751 |    24 | 2662 |
| features/FEATURE_IPV4      |    96 |     0 |   48 |
| frameworks/greentea-client |   912 |    28 |   44 |
| frameworks/utest           |  3079 |     0 |  732 |
| Subtotals                  | 62686 |  2288 | 8500 |
+----------------------------+-------+-------+------+
Allocated Heap: 65540 bytes
Allocated Stack: 32768 bytes
Total Static RAM memory (data + bss): 10788 bytes
Total RAM memory (data + bss + heap + stack): 109096 bytes
Total Flash memory (text + data + misc): 66014 bytes

```

## Information on memory sections

The table above showed multiple memory sections.

- ``.text``: is where the code application and constants are located in Flash.
- ``.data``: non-zero initialized variables; allocated in both RAM and Flash memory (variables are copied from Flash to RAM at run time)
- ``.bss``: uninitialized data allocated in RAM, or variables initialized to zero.
- ``Heap``: dynamic allocations in the Heap area in RAM (for example, used by ``malloc``). The maximum size value may be defined at build time.
- ``Stack``: dynamic allocations in the Stack area in RAM (for example, used to store local data, temporary data when branching to a subroutine or context switch information). The maximum size value may be defined at build time.

There are other entries that require a bit of clarification:

- Fill: represents the bytes in multiple sections (RAM and Flash) that the toolchain has filled with zeros because it requires subsequent data or code to be aligned appropriately in memory.
- Misc: usually represents helper libraries introduced by the toolchain (like ``libc``), but can also represent modules that are not part of mbed.

## Current support

*memap* has been tested on Windows 7, Linux and Mac OS X and works with memory map files are generated by the GCC_ARM, ARM (ARM Compiler 5) and IAR toochains.

## Known issues and new features

This utility is considered 'alpha' quality at the moment. The information generated by this utility may not be fully accurate and may vary from one toolchain to another.

If you are experiencing problems, or would like additional features, please raise a ticket on [GitHub](https://github.com/mbedmicro/mbed/issues) and use ```[memap] ``` in the title.
