#include "mbed.h"
#include "nexpaq_mdk.h"

DigitalOut ledR(P2_4, LED_OFF);
DigitalOut ledG(P2_5, LED_OFF);
DigitalOut ledB(P2_6, LED_OFF);
DigitalIn button(P0_1, PullUp);

/***** Definitions *****/
#define		FUNCTION_TABLE_NUM					1
#define		UUID_NUM							16			//UUID number is 16, don't change it
#define     LOOP_DELAY                          100

/***** Globals *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len);
const MDK_REGISTER_CMD my_cmd_func_table[FUNCTION_TABLE_NUM] = {
    {0x2700, my_function_CMD_2700},		// Command -> function
};

int lastBtn = 1;
unsigned char btnPress = 0x01;

/***** Functions *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
    ledR = (pData[0]>0) ? LED_ON : LED_OFF ;
    ledG = (pData[1]>0) ? LED_ON : LED_OFF ;
    ledB = (pData[2]>100) ? LED_ON : LED_OFF ;
    np_api_upload(0x2701, &response, 1);
}

/******************************************************************************/
void app_setup()
{
    if ( np_api_register((MDK_REGISTER_CMD*)my_cmd_func_table, FUNCTION_TABLE_NUM) == MDK_REGISTER_FAILD ) {
        // Register failed handle code
        error("MDK Register Failed");
    }
}

void app_loop()
{
    if (!button && lastBtn) {
        np_api_upload(0x2800, &btnPress, 1);
    }
    lastBtn = button;
}

int main(void)
{

    np_api_init();
    app_setup();
    np_api_start();
    while(1) {
        Thread::wait(LOOP_DELAY);
        app_loop();
        np_api_bsl_chk();
    }

    return 0;
}

