/*
 * np_app_spi.h
 *
 *  Created on: July 14, 2016
 *      Author: Alan.Lin
 *
 *  Copyright: NexPack Ltd.
 */

#ifndef NP_APP_SPI_H_
#define NP_APP_SPI_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

#define FIFO_SPI_DATA_LENGTH		80
#define FIFO_BUFFER_OVERLOAD		FIFO_SPI_DATA_LENGTH-1
#define FIFO_MESSAGE_LENGTH			8
#define FIFO_MESSAGE_OVERLOAD		FIFO_MESSAGE_LENGTH-1
#define SPI_BUSY					0x01
#define SPI_FREE					0x00
typedef struct {
	uint8_t buffer[FIFO_SPI_DATA_LENGTH];
	uint8_t message_len[FIFO_MESSAGE_LENGTH];
	uint8_t get_buffer_pointer;
	uint8_t readout_buffer_pointer;
	uint8_t get_message_pointer;
	uint8_t readout_message_pointer;
	uint8_t message_num;
	uint8_t used_buffer_length;
} FIFO_GET;
typedef struct {
	uint8_t buffer[FIFO_SPI_DATA_LENGTH];
	uint8_t message_len[FIFO_MESSAGE_LENGTH];
	uint8_t fillin_buffer_pointer;
	uint8_t post_buffer_pointer;
	uint8_t fillin_message_pointer;
	uint8_t post_message_pointer;
	uint8_t message_num;
	uint8_t used_buffer_length;
} FIFO_POST;

extern FIFO_GET spi_get_buf;
extern FIFO_POST spi_post_buf;
extern uint8_t spi_status;

void np_app_spis_message (uint8_t spi_read);
void np_app_spi_apply_post(void);
uint32_t np_app_spi_is_aviable(void);

#ifdef __cplusplus
}
#endif

#endif /* NP_APP_SPI_H_ */
