/*
 * np_app_pm.h
 *
 *  Created on: July 14, 2016
 *      Author: Alan.Lin
 *
 *  Copyright: NexPack Ltd.
 */

#ifndef NP_APP_PM_H_
#define NP_APP_PM_H_

#ifdef __cplusplus
extern "C" {
#endif

extern uint8_t wakeup_run_loop_flag;
extern uint8_t flag_on_lpm;
extern uint8_t developer_lpm4_setting;

void np_function_set_run_the_loop(uint8_t t_data);
uint8_t np_function_get_run_the_loop(void);
void np_function_lpm0_automode_set(void);
void np_function_lpm0_automode_clear(void);
uint8_t np_function_pm_mode_get(void);
void np_function_pm_loop(void);
void np_function_lpm4_automode_set(void) ;
void np_function_lpm4_automode_clear(void) ;
void np_function_enter_lpm4_work(void);
void np_function_exit_lpm4_work(void);
uint8_t np_function_get_lpm_status(void);

#if 0
void np_api_start();							//unused
void np_api_stop();							//unused

//The low power consumption of np_module_mdk_v1.h
//low power consumption function. Function temporarily don't open.
typedef enum{
	LPM_NONE = 0x00,
	LPM_0    = 0x01,
	LPM_1    = 0x02,	//unused
	LPM_2    = 0x04,	//unused
	LPM_3    = 0x08,	//unused
	LPM_4    = 0x10
}E_LPM;

void np_api_enter_lpm4_work();
void np_api_exit_lpm4_work();

/*
 * Description: set auto power lpm0 mode
 * Parameter: null
 * Return: null
 */
void np_api_lpm0_automode_set(void);
/*
 * Description: clear auto power lpm0 mode
 * Parameter: null
 * Return: null
 */
void np_api_lpm0_automode_clear(void);


/*
 * Description: set auto power lpm4 mode
 * Parameter: null
 * Return: null
 */
void np_api_lpm4_automode_set(void) ;

/*
 * Description: clear auto power lpm4 mode. only clear the lpm4 enable flag.
 				It is effective when software is not on lpm4. 
 				You can use "np_api_lpm4_automode_clear_and_wakeup() " to clear the lpm4 mode when wakeup lpm4 by io interrupt.
 * Parameter: null
 * Return: null
 */				   
void np_api_lpm4_automode_clear(void);

/*
 * Description: clear auto power lpm4 mode and exit lpm4 sleep status.
 				The api is used at io interrupt for wakeup lpm4 and clear lpm4 mode.
 				The api only available within interrupt routines.
 * Parameter: null
 * Return: null
 */				   
#define np_api_lpm4_automode_clear_and_wakeup() do{\
													if (np_api_lpm_status_get() == LPM_4){\
														np_mdk_exit_lpm4_work();\
														__bic_SR_register_on_exit(LPM4_bits);\
													}\
													np_mdk_lpm4_automode_clear_flag();\
													np_mdk_start_loop_head_set();\
												  }while(0)

/*
 * Description: API to run the loop once by wake up lpm0/lpm4 once.After the loop once, software will enter lpm again.
 f				The api only available within interrupt routines.
 				If you want to exit lpm4, please using the api to wakeup lpm4 when io interrupt is comming.
 				The api also can wakeup lpm0.
 * Parameter: null
 * Return: null
 */
#define np_api_wake_up_lpm_once() do{\
									if (np_api_lpm_status_get() == LPM_4){\
										np_mdk_exit_lpm4_work();\
										__bic_SR_register_on_exit(LPM4_bits);\
									}else if(np_api_lpm_mode_get() & LPM_0){np_mdk_set_run_the_loop(1);}\
									np_mdk_start_loop_head_set();\
							      }while(0)
							     
/*
* Description: run the loop once by wake up lpm0 once.After the loop once, software will enter lpm again.
* Parameter: null
* Return: null
*/
#define	np_api_wake_up_lpm0_once()	do{\
								 		if(np_api_lpm_mode_get() & LPM_0){np_mdk_set_run_the_loop(1);}\
							 		}while(0)


/*
 * Description: get power status(), now software sleep at LPM_X;
 * Parameter: null
 * Return: E_LPM
 */
uint8_t np_api_lpm_status_get(void);

/*
 * Description: get the power mode, please reference "E_LPM";
 * Parameter: null
 * Return: pm mode.Such as:
 		   if only set the lpm0/lpm4 mode, return "lpm0"/"lpm4".
 		   if set the lpm0 and lpm4,  return "lpm0 | lpm4".
 */
uint8_t np_api_lpm_mode_get(void);
				   
/******************The following API functions are not used by developer. please not used it*******************/
void np_mdk_lpm4_automode_clear_flag(void);
void np_mdk_exit_lpm4_work(void);
void np_mdk_set_run_the_loop(uint8_t t_data);
void np_mdk_start_loop_head_set(void);
/*********************************************************************************************************/
#endif

#ifdef __cplusplus
}
#endif

#endif /* NP_APP_PM_H_ */
