#include "mbed.h"
#include "nexpaq_mdk.h"

DigitalOut ledR(P2_4, LED_OFF);
DigitalOut ledG(P2_5, LED_OFF);
DigitalOut ledB(P2_6, LED_OFF);
DigitalIn button(P0_1, PullUp);

/***** Definitions *****/
#define		FUNCTION_TABLE_NUM					1
#define		UUID_NUM							16			//UUID number is 16, don't change it
#define     BUTTON_DEBOUNCE                     5
#define     DBG_MSG

/***** Globals *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len);
const MDK_REGISTER_CMD my_cmd_func_table[FUNCTION_TABLE_NUM] = {
		{0x2700, my_function_CMD_2700},		// Command -> function
};

int btnCnt = 0;
int btnSts = 0;
unsigned char btnPress = 0x01;

/***** Functions *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len){
	unsigned char response = 0x00;
	ledR = (pData[0]>0) ? LED_ON : LED_OFF ;
	ledG = (pData[1]>0) ? LED_ON : LED_OFF ;
	ledB = (pData[2]>0) ? LED_ON : LED_OFF ;
	np_api_upload(0x2701, &response, 1);
#ifdef DBG_MSG            
    printf("LED Command Received\n\r");  
#endif            
}

/******************************************************************************/
void app_setup(){
//	np_api_set_app_version(0, 0, 3);
	if ( np_api_register((MDK_REGISTER_CMD*)my_cmd_func_table, FUNCTION_TABLE_NUM) == MDK_REGISTER_FAILD ) {
		// Register failed handle code
		error("MDK Register Failed");
	}
#ifdef DBG_MSG            
    printf("MDK Commands Registered\n\r");  
#endif            
}

void app_loop() {
	if (btnSts) {
		btnCnt = (button) ? 0 : (btnCnt + 1);
		if (btnCnt >= BUTTON_DEBOUNCE) {
			np_api_upload(0x2800, &btnPress, 1);
			btnSts = !btnSts;
			btnCnt = 0;
#ifdef DBG_MSG            
      		printf("Button Pressed\n\r");  
#endif            
		}
	} else {
		btnCnt = (!button) ? 0 : (btnCnt + 1);
		if (btnCnt >= BUTTON_DEBOUNCE) {
			btnSts = !btnSts;
			btnCnt = 0;
		}	
	}
}

int main(void){
	np_api_init();
	app_setup();
	np_api_start();	
	while(1){
		app_loop();	
		np_api_bsl_chk();
    	Thread::wait(50);
	}
	return 0;
}

