/*
 * np_driver_timer.c
 *
 *  Created on: July 14, 2016
 *      Author: Alan.Lin
 *
 *  Copyright: NexPack Ltd.
 */

#include "np_config.h"
#include "tmr_regs.h"
#include "mxc_sys.h"
#include "np_driver_timer.h"
#include "np_app_ncn_interface.h"

void TMR0_IRQHandler(void){
	MXC_TMR0->intfl = MXC_TMR0->intfl;

	np_function_ncn_interface_loop();

//	if ( !(np_function_pm_mode_get() & LPM_0)) {
//		__bic_SR_register_on_exit(LPM0_bits);
//		wakeup_run_loop_flag = 1;
//	} else if ( np_function_get_run_the_loop()) {
//		__bic_SR_register_on_exit(LPM0_bits);
//		wakeup_run_loop_flag = 1;
//		np_function_set_run_the_loop(FALSE);
//	}
}


//32 bit timer0 initial, 1 MS trigger interrupt, the lowest priority of interrupt
void Timer0_initial(void){
	MXC_TMR0->ctrl &= ~MXC_F_TMR_CTRL_ENABLE0;

	MXC_TMR0->ctrl &= ~MXC_F_TMR_CTRL_TMR2X16;
	MXC_TMR0->ctrl |= (0x01 << MXC_F_TMR_CTRL_MODE_POS)|(12 << MXC_F_TMR_CTRL_PRESCALE_POS);
	MXC_TMR0->count32 = 24;
	MXC_TMR0->term_cnt32 = 24;
	MXC_TMR0->inten |= MXC_F_TMR_INTEN_TIMER0;

	MXC_TMR0->ctrl |= MXC_F_TMR_CTRL_ENABLE0;

	NVIC_SetPriority(TMR0_0_IRQn,15);
	NVIC_EnableIRQ(TMR0_0_IRQn);
}
