/*
 * np_comand.h
 *
 *  Created on: July 14, 2016
 *      Author: Alan.Lin
 *
 *  Copyright: NexPack Ltd.
 */

#ifndef NP_COMAND_H_
#define NP_COMAND_H_

typedef enum COMMAND_WORD {
	//All the Lowest bit of the request command is 0,
	//and Lowest bit of it's response command is 1,
	//If the Lowest bit of the command is 1,means that it doesn't need a response command.
		REQ_INTO_APP			= 0x0800,		//0x07D3
			RSP_INTO_APP		= 0x0801,
		REQ_EARSE_FLASH			= 0x0802,		//0x07D4
			RSP_EARSE_FLASH		= 0x0803,
		REQ_WRITE_FLASH			= 0x0804,		//0x07D5
			RSP_WRITE_FLASH		= 0x0805,
		REQ_INTO_BSL			= 0x0806,		//0x07D6
			RSP_INTO_BSL		= 0x0807,
		ASK_UUID				= 0x0808,		//0x07E7
			ANS_UUID			= 0x0809,		//0x07EA
		ASK_BSL_INFO			= 0x080A,		//0x07E8
			ANS_BSL_INFO		= 0x080B,		//0x07EB
		ASK_APP_INFO			= 0x080C,		//0x07E9
			ANS_APP_INFO		= 0x080D,		//0x07EC
		ASK_STATUS				= 0x080E,		//0x07C0
			ANS_STATUS			= 0x080F,		//0x07C1
		REQ_EARSE_APP_AND_INFO	= 0x0810,
			RSP_EARSE_APP_AND_INFO = 0x0811,

		CMD_MDK_REQ_START		= 0x0812,
			CMD_MDK_RSP_START	= 0x0813,
		CMD_MDK_REQ_STOP		= 0x0814,
			CMD_MDK_RSP_STOP	= 0x0815,
		CMD_MDK_REQ_LPM4		= 0x0816,
			CMD_MDK_RSP_LPM4	= 0X0817,

		ASK_MODULE_NODE			= 0x0900,		//0x07D1
			ANS_MODULE_NODE		= 0x0901,
		ASK_MODULE_LAST_CTR		= 0x0902,		//0x07C6
			ANS_MODULE_LAST_CTR	= 0x0903,		//0x07C7
		REQ_KILL_MODULE			= 0x0904,		//0x0802
			RSP_KILL_MODULE		= 0x0905,

		REQ_ALLOT_NODE			= 0x0B00,		//0x07D0
			RSP_ALLOT_NODE		= 0x0B01,
		ASK_MODULE_NUM			= 0x0B02,		//0x07EE
			ANS_MODULE_NUM		= 0x0B03,		//0x07EF
		REQ_REGISTER_USB		= 0x0B04,
			RSP_REGISTER_USB	= 0x0B05,
		REQ_CANCEL_USB			= 0x0B06,
			RSP_CANCEL_USB		= 0x0B07,
		REQ_UPDATE_PH_POWER		= 0x0B08,
			RSP_UPDATE_PH_POWER = 0x0B09,

		CTR_BLE_SWITCH			= 0x0A00,		//0x07D8
			STATUS_BLE_SWITCH	= 0x0A02,		//0x07D9
		CASE_APPLY_INTO_APP		= 0x0A04,		//0x07E3

		REQ_USB_SW				= 0x1F00,
			RSP_USB_SW			= 0x1F01,
		/*Data message DOWNLOAD*/
		REQ_DOWNLOAD_GROUP		= 0x2700,
		REQ_DOWNLOAD			= 0x2700,		//0x0801
			RSP_DOWNLOAD		= 0x2701,
		REQ_DOWNLOAD_02			= 0x2702,		//0x0811
			RSP_DOWNLOAD_02		= 0x2703,
		REQ_DOWNLOAD_04			= 0x2704,		//0x0812
			RSP_DOWNLOAD_04		= 0x2705,
		REQ_DOWNLOAD_06			= 0x2706,
			RSP_DOWNLOAD_06		= 0x2707,
		/*Data message UPLOAD*/
		REQ_UPLOAD				= 0x2800,		//0x0901
	//		RSP_UPLOAD			= 0x1281,
			BAT_POWER_MSG		= 0x4600,		//0x0901(Now just for battery message)  - CASE
		REQ_BAT_CTR				= 0x4602,		//0x0801(Now just for control battery)  - CASE
			RSP_BAT_CTR			= 0x4603,

		/*ERROR cmd*/
		ERROR_NO_CMD			= 0x0480,		//Answer if can not parse the command.

		REQ_TEST_COMM			= 0x5100,		// 1.get mdk version ; 2.for Pc_software using ,testing communication and reback data. default 1.
			RSP_TEST_COMM		= 0x5101,
		REQ_SYSTEM_SWITCH 		= 0x1F1D,		//only for test
			RSP_SYSTEM_SWITCH	= 0x1F1E

} COMMAND_words;

#endif /* NP_COMMAND_H_ */
