/*QUESTA è LA VERSIONE PER IL GPS SU ethernet*/

#include "mbed.h"
#include "rtos/rtos.h"
#include "Teseo-LIV3F.h"
#include <cstdlib>
#include <vector>
#include "XNucleoIKS01A2.h"
#include <algorithm>
#include "EthernetInterface.h"
#include "NTPClient.h"


/*IP E AFFINI*/

const char * IP = "192.168.1.206";//"169.254.112.125";
const char * MASK = "255.255.255.0";
const char * GATEWAY = "192.168.1.1";



/*cose imu*/

#define ECHO_SERVER_PORT   7  

static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);
Timer t;

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);



/*cose per gps*/
static Thread t1;
static Thread t2;

static Mutex message_access;

static Timer system_timer;
static Serial usb_serial(USBTX, USBRX, 9600);
static Serial *serial_debug= &usb_serial;

static std::vector<int> ids;



static Teseo_LIV3F Teseo(D8,       D13,        D6,      PE_7,          PE_8,          &usb_serial);


struct gps_coordinate{
    float lat;
    char lat_cardinal;
    float longitud;
    char long_cardinal;
    bool valid;
    
    
    
    };
    
    gps_coordinate myPosition;



/*cose per sensori*/

static Thread t3;




/* Retrieve the composing elements of the expansion board */


/*THIS FUNCTION IS SIMPLY USED TO PRINT ON SERIAL THE NMEA MSG*/
/*
void print_function (enum nmea_msg_id id, char *buf, int len){
    
    if (id == NMEA_END__) {
        puts("Not found\n\r");
        return;
    }

    if (!len) {
        puts("Not valid\n\r");
        return;
    }
    printf("notify: %d " , id);
    for (int i = 0; i < len; ++i)
        printf("%c",buf[i]);
    puts("\n\r");
    
    
    
}
*/
/*THIS FUNCTION PRINT ONLY THE MESSAGE WITH ID SAVED IN STATIC VARIALBE ids*/
/*
void getSpectificMsg (){
    
    enum nmea_msg_id id;
    
    Teseo.Reset(serial_debug);
    Teseo.startListener(serial_debug);

    while(1) {
        
        osEvent evt = Teseo.queue.get();
        if (evt.status == osEventMessage){
           
            
            struct teseo_msg *message = (struct teseo_msg *)evt.value.p;
            if (message->len){
                id = Teseo.MsgDetect(message->buf, message->len, serial_debug);
            }
            
            if ( find(ids.begin(), ids.end(), id) != ids.end() ){
                print_function (id, message->buf, message->len);
            }
           
          
            
            
            
            Teseo.mpool.free(message);
           
        }           
               
               
        
           
              

    }
    
}




*/


int main() {
    
  
    
    //cpose per comunicazioni

     
   
    
    EthernetInterface eth;
    eth.init(IP,MASK,GATEWAY); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
   
  
      
    UDPSocket server;
    server.bind(ECHO_SERVER_PORT);

    
    Endpoint client;
    char buffer[256];
    char outBuffer[256];
    int32_t  packetnumber =0;
    
     
    NTPClient ntp;
    ntp.setTime("169.254.92.70", 123);

       
     time_t ctTime;
     ctTime = time(NULL);
     printf("Time is set to (UTC): %s\r",  ctime(&ctTime));
    
    while(1) {

        printf("\nWaiting for UDP packet...\n");
        
        myled1=1;
        int n = server.receiveFrom(client, buffer, sizeof(buffer));
        buffer[n] = '\0';
        
        printf("Received packet from: %s\n", client.get_address());
        printf("Packet contents : '%s'\n",buffer);
        
        
        //set time
        NTPClient ntp;
        ntp.setTime(client.get_address(), 123,10000);
    
       
        time_t ctTime;
        ctTime = time(NULL);
        printf("Time is set to (UTC): %s\r",  ctime(&ctTime));
         time_t offset = time(NULL);
        t.start();
        
        
        printf("Start Sending GPS messages\n");
        
        myled2=1;
        
        myled3=1;
        printf ("start sending command\n");
        server.sendTo(client, buffer, n);
        Teseo.SendCommand(Teseo_LIV3F::ENABLEALL);
        Teseo.SendCommand(Teseo_LIV3F::SAVE);
        Teseo.SendCommand(Teseo_LIV3F::REBOOT);
        Teseo.SendCommand(Teseo_LIV3F::ENABLEALL2);
        Teseo.SendCommand(Teseo_LIV3F::SAVE);
        Teseo.SendCommand(Teseo_LIV3F::REBOOT);
        printf ("ends sending command\n");
        memset (&buffer[0], '\0', sizeof(buffer));
            while (1){
                packetnumber =packetnumber+1;
                //send imu
                
                if (Teseo._uart.readable()) {
                    int c = Teseo._uart.getc();
                    sprintf (buffer + strlen(buffer), "%c", c);
                    //serial_debug->putc(c);
                    if (c =='\n'){
                       // sprintf (outBuffer , "%d,%s",(t.read_ms()+(offset*1000)),buffer);
                         sprintf (outBuffer , "%s",buffer);
                        
                        n =sizeof (outBuffer);
                        server.sendTo(client, outBuffer, n);
                        memset (&buffer[0], '\0', sizeof(buffer)); 
                        memset (&outBuffer[0], '\0', sizeof(outBuffer));
                        
                        
                        }
                }
                
                
                
               
                //printf (buffer);
                
                //wait (1);
                }
   
     
    
        
        }
}
