/*
 * -------------------------------------------------------------------------
 * Copyright (C) 2017  STMicroelectronics
 * Author: Francesco M. Virlinzi  <francesco.virlinzi@st.com>
 *
 * May be copied or modified under the terms of the GNU General Public
 * License V.2 ONLY.  See linux/COPYING for more information.
 *
 * -------------------------------------------------------------------------
 */
#ifndef __TESEO_LIV3F_H__
#define __TESEO_LIV3F_H__

#include "mbed.h"
#include "rtos/rtos.h"

extern char _OK[];
extern char _Failed[];
extern char X_Nucleo_name[];

enum nmea_msg_id {
    NMEA_GPGGA,     //0
    NMEA_GPGLL,     //1 
    NMEA_GNGSA,     //2
    NMEA_GPTXT,     //3
    NMEA_GPVTG,     //4
    NMEA_GPRMC,     //5
    NMEA_PSTMCPU,   //6
    NMEA_PSTMVER,   //7
    NMEA_END__      //8
};

#define TESEO_RXBUF_LEN 128

struct teseo_msg {
    unsigned char len;
    char buf[TESEO_RXBUF_LEN];
};


class Teseo_LIV3F {
public:
    enum cmd_enum {
        GETSWVER,
        FORCESTANDBY,
        RFTESTON,
        RFTESTOFF,
        LOWPOWER,
        FWUPDATE,
        ENABLEALL,
        SAVE,
        REBOOT,
        ENABLEALL2,
    };
    
    
        Serial      _uart;
    bool        _uart_interleaded;
    bool        _uart_discard;

private:
    DigitalOut   _reset;
    DigitalIn    _pps;
    DigitalOut   _wakeup;

#define SDT_UART_BAUD                   9600
#define FWU_UART_BAUD                   115200
#define TESEO_I2C_ADDRESS               0x3A
#if 1
#define POWERON_STABLE_SIGNAL_DELAY_MS  150
#else
#define POWERON_STABLE_SIGNAL_DELAY_MS  500
#endif


#if 1
    Mutex   _uart_mutex;
#define _uart_mutex_lock()      _uart_mutex.lock()
#define _uart_mutex_unlock()    _uart_mutex.unlock()
#else
#define _uart_mutex_lock()
#define _uart_mutex_unlock()
#endif
    Serial      *_serial_debug;
    I2C         *_i2c;

    int FwWaitAck();

    int CRC_(char *buf, int size);

    int SendString(char *buf, int len);

    int ReadMessage(char *buf, unsigned long len, Timer *t = NULL, float timout = 0.0);

    char *DetectSentence(const char *cmd, char *buf, unsigned long len);

    Thread serialStreamThread;

public:
    enum nmea_msg_id MsgDetect(char *buf, int buf_len, Serial *serial_debug);

    void UARTStreamProcess(Serial *serial_debug);

    Teseo_LIV3F(PinName reset_pin, PinName wakeup_pin, PinName pps_pin, PinName uart_tx_pin, PinName uart_rx_pin, Serial *serial_debug = NULL);

    Teseo_LIV3F(PinName reset_pin, PinName wakeup_pin, PinName pps_pin, PinName uart_tx_pin, PinName uart_rx_pin, I2C *i2c_bus, Serial *serial_debug = NULL);

    void SendCommand(enum Teseo_LIV3F::cmd_enum c);

    void Reset(Serial *serial_debug = NULL);

    bool CheckPPSWorking();

    int CheckI2C();

    void RFTest(bool enable);

    bool WaitBooting(Timer *t, float timout = 8.0);

    int WakeUp();

    int EnableLowPower();

    char *ReadSentence(const char *cmd, char *buf, unsigned long len);

    bool FirmwareUpdate(bool is_recovery, char *data, unsigned int data_len, unsigned long crc, Serial *serial_debug);

    void ReadLoop(Serial *serial_debug);

    void startListener(Serial *serial_debug);
    void stopListener(Serial *serial_debug);

    MemoryPool<struct teseo_msg, 8> mpool;
    Queue<struct teseo_msg, 8>      queue;
};

#endif