#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
AnalogIn LM35(p20);
AnalogIn LDR(p19);

#define TRANSFER_SIZE   6

char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];

int txDataCnt = 6;
int rxDataCnt = 0;

float Light = 0;
float TemperatureC = 0;
char a[6]; //temp
char b[6];//licht
float i = 0;//temp
float j = 0;//licht

int main() {

// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
// "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
// Only handles 4 byte transfers in the ATMega code.
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTxAddress(0xE7E7E7E7E7,5);
    my_nrf24l01p.setRfFrequency(2450);
    my_nrf24l01p.setRfOutputPower(0);    
    
    
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency()   );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate()   );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress()   );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(0)  );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    //Put device in receivemode
    my_nrf24l01p.setReceiveMode();             
    my_nrf24l01p.enable();


    while (1) {
        wait(0.2); 
        i = 0;
        j = 0;
        txDataCnt = 6;
        
        for (int t = 0; t < 100; t++)
        {
            i = i + LM35.read();     
        }
        for (int y = 0; y < 100; y++)
        {
            j = j + LDR.read();     
        }
        pc.printf("Temperatuur in %4.1f graden C \n\r", i * 3.3);    
        pc.printf("Lichtsterkte in %4.1f procent \n\r", j);     
           
        sprintf(a, "%f", i * 3.3); //float to char
        sprintf(b, "%f", j); //float to char
        /*
        pc.printf("a %f \n\r", a);       
        pc.printf("a1 %c \n\r", a[0]);
        pc.printf("a2 %c \n\r", a[1]);
        pc.printf("a3 %c \n\r", a[2]);
        pc.printf("a4 %c \n\r", a[3]);
        pc.printf("a5 %c \n\r", a[4]);                               
        */
        
        
        for(int x = 0; x <=5; x++)
        {
        txData[x] = a[x];
        /*pc.printf("txData[0] %c \n\r", txData[0]);
        pc.printf("txData[1] %c \n\r", txData[1]);
        pc.printf("txData[2] %c \n\r", txData[2]);
        pc.printf("txData[3] %c \n\r", txData[3]);
        pc.printf("txData[4] %c \n\r", txData[4]); */   
        }
        txData[5] = 'T';
        // Toggle LED1 debug(Temperatuur)
        myled1 = !myled1;
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        pc.printf("Ik heb mijn temperatuur verzonden\r\n");
        wait(0.3); 
        for(int x = 0; x <=5; x++)
        {
            txData[x] = b[x];
        /*pc.printf("txData[0] %c \n\r", txData[0]);
        pc.printf("txData[1] %c \n\r", txData[1]);
        pc.printf("txData[2] %c \n\r", txData[2]);
        pc.printf("txData[3] %c \n\r", txData[3]);
        pc.printf("txData[4] %c \n\r", txData[4]); */   
        }
        txData[5] = 'L';
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        pc.printf("Ik heb mijn lichtwaarde verzonden\r\n");
        // Toggle LED2 debug(lichtwaarde)
        myled2 = !myled2;
    }
}
                                                     