#include "mbed.h"
#include "nRF24L01P.h"
#include "TextLCD.h"
#include "SerialRPCInterface.h"
SerialRPCInterface SerialInterface(USBTX, USBRX);
Serial pc(USBTX, USBRX); // tx, rx
TextLCD lcd(p15, p16, p21, p22, p23, p24); // rs, e, d4-d7
nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut ledlicht(p30);
DigitalOut lednorm(p29);
DigitalOut leddonk(p28);
char a[5]; //temp
char b[5];//licht
char buffer[6];//buffer
char aa = '?';//temp
char bb = '?';//licht
float temp = 0;//rpc
float licht = 0;//rpc

RPCVariable<float> rpc_temp(&temp,"temp");
RPCVariable<float> rpc_licht(&licht,"licht");

int main() 
{
    //Labview
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<DigitalInOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<SPI>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<Serial>();
    
    char buf[256], outbuf[256];
    
    #define TRANSFER_SIZE   6

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0; 
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();
    
    //Set Device
    my_nrf24l01p.setTxAddress(0xE7E7E7E7E7,5);
    //my_nrf24l01p.setRxAddress(0xE7E7E7E7E7,5);
    my_nrf24l01p.setRfFrequency(2450);
    my_nrf24l01p.setRfOutputPower(0);

    // Display the (default) setup of the nRF24L01+ chip
   // pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
   // pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
   // pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
   // pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
   // pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(0) );

    //pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();


    
    lcd.cls();//LCD clear
    lcd.locate(0,0);
    lcd.printf("Project wireless");
    lcd.locate(0,1);
    lcd.printf("Bjorn Vranken");
    lcd.locate(0,1);
    wait(1);
    lcd.printf("Michiel VEndert");
    lcd.locate(0,1);
    wait(1);
    lcd.printf("Nino DerKinderen");
    wait(2);
    
    lcd.cls();//LCD clear
    lcd.locate(0,0);
    lcd.printf("Temp:");
    lcd.locate(0,1);
    lcd.printf("Licht:");
    lcd.locate(12,0);
    lcd.printf("C");
    lcd.locate(12,1);
    lcd.putc(37);
    
    temp = 10;
    licht = 50;
    
    while (1) 
    {
        pc.gets(buf,256);
        rpc(buf,outbuf);
        pc.printf("%s\n",outbuf);
       
        for(int i = 0;i <= 20; i++)
        {
            wait(0.05);
        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) {
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );

            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) 
            {
                buffer[i] = rxData[i];
                //pc.putc( rxData[i] );          
            }

            // Toggle LED1 (to help debug nRF24L01+ -> Host communication)
            myled1 = !myled1;
            //pc.printf("\r\n");
            
            if (buffer[5] == 'T')
            {
                //pc.printf("Temperatuur\r\n");
                for(int x = 0; x <=4; x++)
                {
                     a[x] = buffer[x];
                     aa = a[x];
                     lcd.locate(6+x,0);
                     lcd.putc(aa);
                }
                temp = atof(a);
                //pc.printf("t : %f \r\n",temp);
            }
            else if (buffer[5] == 'L')
            {
               //pc.printf("Lichtwaarde\r\n");
                for(int x = 0; x <=4; x++)
                {
                     b[x] = buffer[x];
                     bb = b[x];
                     lcd.locate(6+x,1);
                     lcd.putc(bb);
                }
                licht = atof(b);
                //pc.printf("l : %f \r\n",licht);
                if(licht > 85)
                {
                   ledlicht = 1;
                   lednorm = 0;
                   leddonk = 0;
                }
                else if(licht <= 85 && licht > 30)
                {
                    ledlicht = 0;
                    lednorm = 1;
                    leddonk = 0;
                }
                else if(licht <= 30)
                {
                    ledlicht = 0;
                    lednorm = 0;
                    leddonk = 1;
                }
            }
            else
            {
                //pc.printf("Verkeerde DATA!!!\r\n");
            }
        }
        }
    }
}
