#include "mbed.h"
#include "Motor.h"
#include "Servo.h"
#include "string"

#define SERVO_MOVE 0.005

DigitalOut myled(LED1);
AnalogIn light(p18);
 
RawSerial  pc(USBTX, USBRX);
RawSerial  dev(p13,p14);
DigitalOut l1(p11);
DigitalOut l2(p12);
DigitalOut l3(p10);
DigitalOut led1(LED1);
//DigitalOut led4(LED4);
 
Motor m1(p21, p5, p6);
Motor m2(p22, p7, p8);

Servo horiz(p24);
Servo vert(p23);

Timeout flipper;

void flip() {
    printf("Fire off\n");
    l1 = 0;
    l2 = 0;
    l3 = 0;
}

void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        switch(dev.getc()) {
            case 'm': {
                char xbuf[6];
                char ybuf[6];
                
                int ind = 0;
                char cur = dev.getc();
                while(cur != ',') {
                    xbuf[ind++] = cur;
                    cur = dev.getc();
                }
                xbuf[ind] = NULL;
                
                ind = 0;
                cur = dev.getc();
                while(cur != '|') {
                    ybuf[ind++] = cur;
                    cur = dev.getc();
                }
                ybuf[ind] = NULL;
                
                float x, y;
                x = (float)atof(xbuf);
                y = (float)atof(ybuf);
                
                pc.printf("%f, %f\n",x , y);
                
                if (x >= 0.1) {
                    m1.speed( (y + x) );
                    m2.speed(y);
        //            pc.printf("GREATER THAN %f, %f\n",(y + x) , y);
                } else if (x <= -0.1) {
                    m1.speed(y);
                    m2.speed( (y - x));
        //            pc.printf("LESS THAN %f, %f\n",y, (y - x));
                } else {
                    m1.speed(y);
                    m2.speed(y);
        //            pc.printf("%.2f, %.2f\n",x, y);
                }
            }
            case 's': {
                switch(dev.getc()) {
                    case 'u': {
                        if (vert < 1) {
                            vert = vert + SERVO_MOVE;
                            printf("Servo Command: %f\n", vert.read());
                        }
                        break;
                    }
                    case 'd': {
                        if (vert > 0) {
                            vert = vert - SERVO_MOVE;
                            printf("Servo Command: %f\n", vert.read());
                        }
                        break;
                    }
                    case 'l': {
                        if (horiz < 5) {
                            horiz = horiz + SERVO_MOVE;
                        }
                        break;
                    }
                    case 'r': {
                        if (horiz > 0) {
                            horiz = horiz - SERVO_MOVE;
                        }
                        break;
                    }
                }
                break;
            }
            case 'f': {
                printf("Fire\n");
                l1 = 1;
                l2 = 1;
                l3 = 1;
                flipper.attach(&flip, 60.0);
                break;
            }
        }
    }
}
 
void pc_recv()
{
//    led4 = !led4;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}
 
int main()
{
    pc.baud(9600);
    dev.baud(9600);
    
 
    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
    horiz = 0.5;
    vert = 0.5;
    while(1) {
        sleep();
    }
}