//
// Ian Molesworth October 2010
// SHT 75 class
//
// 
// To do:
//
// 

#include "sht7X.h"

void SHT75::reset()
    {
     _data.output();
    _data = 1;                                        // data bus high
    for (int i=0;i<12;i++)
        {
        _clock = 1;                                   // clock high
        wait_us(1);
        _clock = 0;                                   // clock lo
        wait_us(1);
        }
    _clock = 1;                                   // clock high
        wait_us(1);
    _data  = 0;
        wait_us(1);
    _clock = 0;                                   // clock lo
        wait_us(1);
    _clock = 1;
        wait_us(1);
    _data  = 1;
        wait_us(1);
    _clock = 0;   
        wait_us(1);
    }

void  SHT75::softReset(void)
    {
    _data.output();
    start();
    write(0x1E);
    wait_ms(12);
    }

void  SHT75::start(void)
    {
    _data.output();
    _clock = 1;
    wait_us(1);
    _data = 0;
    wait_us(1);
    _clock = 0;
    wait_us(1);
    _clock = 1;
    wait_us(1);
    _data = 1;
    wait_us(1);
    _clock = 0;
    }

int SHT75::readStatus(void)
    {
    int status;
    status = -1;
    start();
    if (write(0x06) == 0)
        status = read(1);               // read with a wait for ack
    read(0);                            // read without the wait
    return status;
    }

bool SHT75::write(char d)
    {
    auto int i;
    _data.output();                         // bus output
    // Writes char and returns -1 if no ACK was sent from remote
    for (i=0;i<8;i++)
        {
        if (d & 0x80)
            _data = 1;                      // data high
        else
            _data = 0;                      // data lo
        // shift the data
        d <<= 1;
        wait_us(1);
        _clock = 1;                         // clock high
        wait_us(1);
        _clock = 0;                         // clock lo
        }
    _data.input();                          // float the bus
    wait_us(1);
    _clock = 1;                             // clock high
    wait_us(1);
    i = _data;
    _clock = 0;                             // clock lo
    return i;                               // leave the bus in input mode and return the status of the ack bit read.
    }

int SHT75::read(char ack)
    {
    auto int i,s;
    auto char c;
    s = 0;
    _data.input();                            // bus to input
  
    for (i=0;i<8;i++)
        {
        s <<= 1;
        wait_us(1);
        _clock = 1;                              // clock high
        wait_us(1);
        c = _data;                               // get the data bit
        _clock = 0;                             // clock lo
        if ( c )
            s |= 1;
        }

    if (ack == 1)
        _data = 0;                             // data lo
    else
        _data = 1;                             // data hi
    _data.output();
    _clock = 1;                                // clock lo
    wait_us(1);
    _clock = 0;                              // clock lo
    _data = 1;                               // data hi
    _data.input();
    return s;
    }


// Put the current temperature into passed variable
bool SHT75::readTempTicks(int* temp)
{
  int v, value;
  start();                                  // Start a tx ( leaves data as input )
  if (write(0x03) == 0)                     // send the read command and get an ack
        {
        for (v=0; v<50; v ++)               // wait for ready up to 500 ms
            {
            wait_ms(10);                    // 10 ms pause
            if ( _data == 0 )               //
                {
                value = read(1);            // read a byte
                value <<= 8;                // shift it in
                value |= read(1);           // read another byte
                read(0);
                // transfer the value
                 *temp = value;
                reset();
                return true;
                }
            }
        }
    return false;    
    }

bool SHT75::readHumidityTicks(int* humi)
    {
    start();
    if (write(0x05) == 0)
        {
        for (int value=0; value<50; value ++)   // wait for ready up to 500 ms
            {
            wait_ms(10);                        //
            if ( _data == 0 )                   //
                {
                value = read(1);
                value <<= 8;
                value |= read(1);
                read(0);
                *humi = value;                  // transfer the value
                reset();
                return true;
                }
            }
        }
   
    return false;
    }
