
#include "yalgaar_api.h"

Serial pc(USBTX, USBRX,115200);

EthernetInterface  eth;
yalgaar yalgaar_client;


Yalgaar_Error_t ret = FAILURE;
char err_string[YALGAAR_ERROR_MESSAGE_LENGTH] = {'\0'};
int pub_count = 10;

void subscribe_message_callback(char *payload)
{
    pc.printf("subscribe_message_callback :%s\r\n",payload);
}
void presence_message_callback(char *message)
{
    pc.printf("presence_message_callback: %s\r\n",message);
}
void error_message_callback(char *error)
{
    pc.printf("error_message_callback :%s\r\n",error);
}


void connection_Callback(char* error_dec)
{
    if(yalgaar_client.yalgaar_connected())
    {
        pc.printf("connection callback :: %s\r\n",error_dec);
    }
    else
    {
        pc.printf("connection_Callback :%s\r\n",error_dec);
    }
}




int main()
{
    wait(2.0f);
    eth.init(); //Use DHCP
    do pc.printf("Connection...\r\n");
    while (eth.connect() != 0);

    pc.printf("IP Address is %s\r\n", eth.getIPAddress());


    ret = yalgaar_client.yalgaar_connect("YourClientKey","UUID", connection_Callback);
    if (SUCCESS != ret) {
        yalgaar_client.enum_to_message(ret, err_string);
        pc.printf("Connection fail %s \r\n",err_string);
    }
    
       
    if (ret == SUCCESS) {
                
        ret = yalgaar_client.yalgaar_subscribe("YourChannel", subscribe_message_callback, presence_message_callback, error_message_callback);
        
        if (SUCCESS != ret) {
            yalgaar_client.enum_to_message(ret, err_string);
            pc.printf("subscribe failure %s \r\n",err_string);
        }
    } else {
        pc.printf(" try again in 5 seconds\r\n");
        // Wait 5 seconds before retrying
        wait(5.0f);
    }

    while(1) {

        // Once connected, publish an announcement...
        if (yalgaar_client.yalgaar_connected()) {
            if (pub_count) {
                wait(5.0f);
                ret = yalgaar_client.yalgaar_publish("YourChannel", "This is Yalgaar mbed SDK Example");
                if (SUCCESS != ret) {
                    yalgaar_client.enum_to_message(ret, err_string);
                    pc.printf("publish failure %s \r\n",err_string);
                }
                pub_count--;
            }
        }
        yalgaar_client.yalgaar_loop();
    }
}
