/** @fileName <yalgaar_api>
 *  @brief - <Yalgaar SDK APIS>
 *
 *  @Version:V:01:00:000
 *
 *
 * @Copyright:
 * Copyright (c) 2010 System Level Solution (India) pvt.ltd. Corporation.  All rights reserved.
 *
 * License: Free License for Yalgaar Users
 * Disclaimer:
 * SLS MAKES NO REPRESENTATION, WARRANTY, OR CONDITION OF ANY KIND, EXPRESS,
 * IMPLIED, STATUTORY, OR OTHERWISE OR IN ANY COMMUNICATION WITH YOU, INCLUDING,
 * BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, SATISFACTORY
 * QUALITY, FITNESS FOR ANY PARTICULAR PURPOSE, NONINFRINGEMENT, AND THEIR
 * EQUIVALENTS.
 */
#ifndef yalgaar_api_h
#define yalgaar_api_h

#include "PubSubClient.h"

#define YALGAAR_MAX_UUID_STR_COUNT                  10
#define YALGAAR_CLIENT_DEFAULT_STRING_LEN           50
#define YALGAAR_MAX_CHANNEL_NAME_LENGTH             50
#define YALGAAR_ERROR_MESSAGE_LENGTH                255
#define YALGAAR_CLIENT_KEY_MAX_LENGTH               20



#define YALGAAR_HOST                                "api.yalgaar.io"
#define YALGAAR_PORT                                1883

extern int pubsub_error_code;

typedef enum Yalgaar_Error {
    SUCCESS = 1,
    FAILURE = 0,
    CLIENT_NULL=101,
    CLIENT_NOT_VALID=102,
    CLIENT_KEY_NOT_REG=103,
    UUID_NOT_VALID=104,
    CLIENT_KEY_NOT_ACTIVE=105,
    SSL_NOT_ENABLE=106,
    CONNECTION_LIMIT_EXCEED=107,
    SUBCRIPTION_NOT_VALID=108,
    SUBCRIPTION_CLIENT_KEY_NOT_MATCH=109,
    MULTIPLE_SUBCRIBES_NOT_ALLOWED=110,
    SUBCRIBE_CHANNEL_LENGTH_EXCEED=111,
    STORAGE_NOT_ENABLE=112,
    PRESENCE_NOT_ENABLE=113,
    HISTORY_CHANNEL_NOT_SUBCRIBE=114,
    MESSAGE_NOT_NULL=115,
    PUBLISH_CHANNEL_NOT_VALID=116,
    PUBLISH_CLIENT_KEY_NOT_MATCH=117,
    MESSAGE_CNT_EXCEED=118,
    MESSAGE_SIZE_EXCEED=119,
    MESSAGE_LENGTH_EXCEED=120,
    UNSUBSCRIBE_CHANNEL_NOT_VALID=121,
    UNSUBSCRIBE_CLIENT_KEY_NOT_MATCH=122,
    UNSUBSCRIBE_CHANNEL_LENGTH_EXCEED=123,
    YALGAAR_MAX,
    INVL_STRING
} Yalgaar_Error_t;

//class PubSubClient;

class yalgaar: public PubSubClient
{
public:

    yalgaar():PubSubClient() {}
    yalgaar(char *ip, int port):PubSubClient(ip,port) {}
    Yalgaar_Error_t yalgaar_connect(const char* id,const char *uuid,void(*connectionCallback)(char * ));
    void yalgaar_disconnect();
    Yalgaar_Error_t yalgaar_publish(const char* topic, char* payload);
    Yalgaar_Error_t yalgaar_unsubscribe(const char* topic);
    Yalgaar_Error_t yalgaar_subscribe(char * subscribe_channel,void(* sub_mesg_callback)(char *),void(*presence_mesg_callback)(char *), void(*error_msg_callback)(char *));
    Yalgaar_Error_t yalgaar_subscribes(char** subscribe_channel,void(* sub_mesg_callback)(char *),void(*presence_mesg_callback)(char *), void(*error_msg_callback)(char *));
    void connection_state(bool ret);
    void yalgaar_loop();
    bool yalgaar_connected();
    void enum_to_message(int error_msg,char *errorString);
};
#endif