#include <math.h>
#include "mbed.h"
#include "stdint.h"

DigitalOut FSYNC(p8);
DigitalOut CTRL(p30);
DigitalOut STANDBY(p9);
DigitalOut INTERRUPT(p29);
DigitalOut OSC_EN(p24);

SPI device(p5, NC, p7); // mosi, miso-NC, sclk
Serial pc(USBTX, USBRX);

DigitalOut D1(LED1);
DigitalOut D2(LED2);
DigitalOut D3(LED3);
DigitalOut D4(LED4);

AnalogIn gain(p16);
AnalogIn phase(p17);

void Rx_interrupt(); // interrupt routine for serial receive


const int buffer_size = 19;
char buff[buffer_size] = {'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'};
int buff_int[buffer_size] = {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};
volatile int rx_in = 0; //receive buffer pointer
volatile int rx_in_buffered = 0;
volatile int flag = 0; // flag for interrupt routine
char tx_buffer[11];
unsigned int state = 0;
float gain_db = 0;
float phase_degree = 0;





int main() {
    pc.baud(9600); //set the rs232 speed
    device.format(16,2); // required by device, 16 bits transmission, POL=1, PHA=0
    device.frequency(10000000); //CLK 10 MHz
    pc.attach(&Rx_interrupt, Serial::RxIrq); //linking the serial interrupt function Rx_interrupt
    
    //AD5932 init
    OSC_EN = 1;
    INTERRUPT = 0;
    STANDBY = 0;
    FSYNC = 1;
    CTRL = 0;
    wait_ms(100);


    while (1) {
        switch (state) {



            case 0: { //receives the command array from pc
                D1 = 1;
                D2 = 0;
                D3 = 0;
                D4 = 0;
                while (1) {
                        
                  if (flag == 1) {flag =0; break;}
                  
                 
                }
                               
                state = 1;
                break;
            }//end case 0





            case 1: {//decodes if the network analyzer, sine wave, triangle wave or pulse generator have to be deployed
                D1 = 0;
                D2 = 1;
                D3 = 0;
                D4 = 0;
                
                
                if (buff_int[0] == 1) state = 2; // network analyzer selected
                if (buff_int[0] == 2 || buff_int[0] == 3 || buff_int[0] == 4) state = 3; // waveform generator selected
                break;
            
            }//end case 1






            case 2: { // network analyzer mode selected
                D1 = 0;
                D2 = 0;
                D3 = 1;
                D4 = 0;
                uint32_t StartFreq = 0; 
                uint32_t FreqIncrement = 0; 
                uint16_t NumOfPoints = 0; 


                //variables that deal with Start Register
                uint32_t StartFreq32_buffered = 0; // StartReg32 buffered value
                uint16_t StartRegWriteLSB16 = 0; // the value to be written to LSB Start Register
                uint16_t StartRegWriteMSB16 = 0; // the value to be written to MSB Start Register


                //variables that deal with Frequency Increment Register
                uint32_t FreqIncrement32_buffered = 0; // FreqIncrement32_calculated buffered
                uint16_t FreqIncrementRegWriteLSB16 = 0; // the value to be written to LSB Frequency Increment Register
                uint16_t FreqIncrementRegWriteMSB16 = 0; // the value to be written to MSB Frequency Increment Register


                //variables that deal with Number of Increments Register
                uint16_t NumOfIncrementsRegWrite = 0;


                //variable that deals with Control Register
                uint16_t ControlRegWrite = 0x0FFF; // the value written to control register to put device in frequency sweep mode, sine wave
                //uint16_t ControlRegWrite = 0x0DFF; // triangle wave
                //uint16_t ControlRegWrite = 0x0BFF; // dac disabled, sine wave selected

                
                //obtaining the user defined parameters entered via LabView Interface
                StartFreq = buff_int[1]*1000000 + buff_int[2]*100000 + buff_int[3]*10000 + buff_int[4]*1000 + buff_int[5]*100
                            + buff_int[6]*10 + buff_int[7];

                FreqIncrement = buff_int[8]*1000000 + buff_int[9]*100000 + buff_int[10]*10000 + buff_int[11]*1000 + buff_int[12]*100
                                + buff_int[13]*10 + buff_int[14];

                NumOfPoints = uint16_t(buff_int[15]*1000 + buff_int[16]*100 + buff_int[17]*10 + buff_int[18]);
              


                // makes LSB Start Register value
                StartFreq32_buffered = StartFreq;
                StartRegWriteLSB16 = (uint16_t) ((StartFreq32_buffered & 0x0FFF)  | 0xC000); //to be written as the second word to AD5932

                // makes MSB Start Register value
                StartFreq32_buffered = StartFreq32_buffered >> 12;
                StartRegWriteMSB16 = (uint16_t) ((StartFreq32_buffered & 0x0FFF)  | 0xD000); //to be written as the third word to AD5932



                // makes LSB Frequency Increment value
                FreqIncrement32_buffered = FreqIncrement;
                FreqIncrementRegWriteLSB16 = (uint16_t) ((FreqIncrement32_buffered & 0x0FFF)  | 0x2000); //to be written as the fourth word to AD5932

                // makes MSB Frequency Increment value
                FreqIncrement32_buffered = FreqIncrement32_buffered >> 12;
                FreqIncrementRegWriteMSB16 = (uint16_t) ((FreqIncrement32_buffered & 0x0FFF)  | 0x3000); //to be written as the fifth word to AD5932



                // deals with Number of Frequency Increments Register
                NumOfIncrementsRegWrite = (uint16_t) ((NumOfPoints & 0x0FFF)  | 0x1000); //to be written as the sixth word to AD5932


                //Write to AD5932
                FSYNC = 0;
                wait_us(0.1);
                device.write(ControlRegWrite); // sets the control register (frame I)
                wait_us(0.1);
                FSYNC = 1;

                wait_ms(50);

                FSYNC = 0;
                wait_us(0.1);
                device.write(StartRegWriteLSB16); //sets the start frequency LSB (frame II)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);

                FSYNC = 0;
                wait_us(0.1);
                device.write(StartRegWriteMSB16); //sets the start frequency MSB (frame III)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);

                FSYNC = 0;
                wait_us(0.1);
                device.write(FreqIncrementRegWriteLSB16); //sets the frequency increment LSB (frame IV)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);

                FSYNC = 0;
                wait_us(0.1);
                device.write(FreqIncrementRegWriteMSB16); //sets the frequency increment MSB (frame V)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);

                FSYNC = 0;
                wait_us(0.1);
                device.write(NumOfIncrementsRegWrite); // sets the number of increments (frame VI)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);
                
                CTRL=1;  //sets the output
                wait_us(0.4); // wait time for output to get stabilized
                CTRL=0;
               
               
                // for loop: scan
                for (int j = 0; j < NumOfPoints; j++) {
                    D2 = 1;
                    wait_ms(250);
                    
                    gain_db = -30 + (gain.read()*3.3) / 0.03;  // taking the measurement for gain
                    phase_degree = 180 - (phase.read()*3.3) / 0.01; // taking the measurement for phase
                    
                    //sprintf(tx_buffer,"%+5.1f%+6.1f", gain_db, phase_degree);
                    //for (int i = 0; i<11; i++){pc.putc(tx_buffer[i]);}
                    
                   
                    pc.printf("%.1f,%.1f", gain_db, phase_degree); // sends the measurement to the PC
                   
                    
                    CTRL=1;  //increments the output
                    wait_us(0.4); // wait time for output to get stabilized
                    CTRL=0;                   
                   
                    if (flag == 1) break;
                    D2 = !D2;
                    wait_ms(250);
                }

                state = 0;
                 D1 = 1;
                D2 = 1;
                D3 = 1;
                D4 = 1;
                wait_ms(500);
                 D1 = 0;
                D2 = 0;
                D3 = 0;
                D4 = 0;
                break;
            }// end case 2






            case 3: { //waveform generator selected
                D1 = 0;
                D2 = 0;
                D3 = 0;
                D4 = 1;
                uint32_t StartFreq = 0; 
                uint32_t FreqIncrement = 0; 
                uint16_t Resolution = 0; 


                //variables that deal with Start Register
                uint32_t StartFreq32_buffered = 0; // StartReg32 buffered value
                uint16_t StartRegWriteLSB16 = 0; // the value to be written to LSB Start Register
                uint16_t StartRegWriteMSB16 = 0; // the value to be written to MSB Start Register


                //variables that deal with Frequency Increment Register
                uint32_t FreqIncrement32_buffered = 0; // FreqIncrement32_calculated buffered
                uint16_t FreqIncrementRegWriteLSB16 = 0; // the value to be written to LSB Frequency Increment Register
                uint16_t FreqIncrementRegWriteMSB16 = 0; // the value to be written to MSB Frequency Increment Register


                //variables that deal with Number of Increments Register
                uint16_t NumOfIncrementsRegWrite = 0;


                //variable that deals with Control Register
                uint16_t ControlRegWrite = 0;
                if (buff_int[0] == 2) ControlRegWrite = 0x0FFF; // sine wave
                if (buff_int[0] == 3) ControlRegWrite = 0x0DFF; // triangle wave
                if (buff_int[0] == 4) ControlRegWrite = 0x0FFF; // pulse wave + sine wave



                //obtaining the user defined parameters entered via LabView Interface
                StartFreq = buff_int[1]*1000000 + buff_int[2]*100000 + buff_int[3]*10000 + buff_int[4]*1000 + buff_int[5]*100
                            + buff_int[6]*10 + buff_int[7];

                FreqIncrement = buff_int[8]*1000000 + buff_int[9]*100000 + buff_int[10]*10000 + buff_int[11]*1000 + buff_int[12]*100
                                + buff_int[13]*10 + buff_int[14];

                Resolution = uint16_t(buff_int[15]*1000 + buff_int[16]*100 + buff_int[17]*10 + buff_int[18]);



                // makes LSB Start Register value
                StartFreq32_buffered = StartFreq;
                StartRegWriteLSB16 = (uint16_t) ((StartFreq32_buffered & 0x0FFF)  | 0xC000); //to be written as the second word to AD5932

                // makes MSB Start Register value
                StartFreq32_buffered = StartFreq32_buffered >> 12;
                StartRegWriteMSB16 = (uint16_t) ((StartFreq32_buffered & 0x0FFF)  | 0xD000); //to be written as the third word to AD5932



                // makes LSB Frequency Increment value
                FreqIncrement32_buffered = FreqIncrement;
                FreqIncrementRegWriteLSB16 = (uint16_t) ((FreqIncrement32_buffered & 0x0FFF)  | 0x2000); //to be written as the fourth word to AD5932

                // makes MSB Frequency Increment value
                FreqIncrement32_buffered = FreqIncrement32_buffered >> 12;
                FreqIncrementRegWriteMSB16 = (uint16_t) ((FreqIncrement32_buffered & 0x0FFF)  | 0x3000); //to be written as the fifth word to AD5932



                // deals with Number of Frequency Increments Register
                NumOfIncrementsRegWrite = (uint16_t) ((Resolution & 0x0FFF)  | 0x1000); //to be written as the sixth word to AD5932


                //Write to AD5932
                FSYNC = 0;
                wait_us(0.1);
                device.write(ControlRegWrite); // sets the control register (frame I)
                wait_us(0.1);
                FSYNC = 1;

                wait_ms(50);

                FSYNC = 0;
                wait_us(0.1);
                device.write(StartRegWriteLSB16); //sets the start frequency LSB (frame II)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);

                FSYNC = 0;
                wait_us(0.1);
                device.write(StartRegWriteMSB16); //sets the start frequency MSB (frame III)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);

                FSYNC = 0;
                wait_us(0.1);
                device.write(FreqIncrementRegWriteLSB16); //sets the frequency increment LSB (frame IV)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);

                FSYNC = 0;
                wait_us(0.1);
                device.write(FreqIncrementRegWriteMSB16); //sets the frequency increment MSB (frame V)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);

                FSYNC = 0;
                wait_us(0.1);
                device.write(NumOfIncrementsRegWrite); // sets the number of increments (frame VI)
                wait_us(0.1);
                FSYNC = 1;

                wait_us(0.1);
                CTRL=1;  //sets the output
                wait_us(0.4); // wait time for output to get stabilized
                CTRL=0;

             
                state = 0;
                break;
            }// end case 3



        }//end switch
    }//end while(1)

}//end main



// Interupt Routine to read in data from serial port
void Rx_interrupt() {
   
               
    while (pc.readable()) {
        buff[rx_in] = pc.getc();
        buff_int[rx_in] = (int)(buff[rx_in] - '0');
        rx_in_buffered = rx_in;
        rx_in = (rx_in + 1) % buffer_size;
        if(rx_in_buffered == 18){flag = 1;}
     
              
    }
    return;
}