#include "mbed.h"
 
FlashIAP flash;
 
int main() {
    flash.init();
    
    const uint32_t  flash_start = flash.get_flash_start();
    const uint32_t  flash_size = flash.get_flash_size();
    const uint32_t  flash_end = flash_start + flash_size;
    const uint32_t  page_size = flash.get_page_size();
    uint32_t        sector_size = flash.get_sector_size(flash_end - 1);
    uint8_t*        page_buffer = new uint8_t[page_size];
    uint32_t        addr = flash_end - sector_size;   
    uint8_t         EEdata_write; //= 55;
    uint8_t         EEdata_read = 0;
    
    printf("flash_start = 0x%.8x\r\n", flash_start);
    printf("flash_size = 0x%.8x\r\n", flash_size);
    printf("flash_end = 0x%.8x\r\n", flash_end);
    printf("page_size = 0x%.8x\r\n", page_size);
    printf("sector_size = 0x%.8x\r\n", sector_size);
    printf("addr = 0x%.8x\r\n", addr);
    printf("EEdata_write = %d\r\n", EEdata_write);
    printf("EEdata_read = %d\r\n", page_buffer[0]);   
    //page_buffer[0] = 55;//EEdata_write;   
    //flash.erase(addr, sector_size);
    //flash.program(page_buffer, addr, page_size);   
    //page_buffer[0] = 0;   
    //flash.read(page_buffer, addr, page_size);
    //EEdata_read = page_buffer[0];
    //page_buffer[0]++;  
    //flash.erase(addr, sector_size);
    
    //flash.program(page_buffer, addr, page_size);
    flash.read(page_buffer, addr, page_size);
    printf("EEdata_read PB = %d\r\n", page_buffer[0]);
    
    page_buffer[0] = page_buffer[0]+1;
    printf("EEdata_read PB = %d\r\n", page_buffer[0]);
    //temp = page_buffer[0];
    flash.erase(addr, sector_size);
    flash.program(page_buffer, addr, page_size);
    //flash.program(page_buffer, addr, page_size);
    //flash.read(page_buffer, addr, page_size);
    //delete[] page_buffer;
    //flash.deinit(); 
    flash.read(page_buffer, addr, page_size);
    printf("EEdata_read PB = %d\r\n", page_buffer[0]);
}