#include "mbed.h"
#include "FT_Platform.h"
#include <string>

#ifndef DISPLAY_H_
#define DISPLAY_H_

/**************************************************************************************************************************
************************** Defines using for drawing **********************************************************************
**************************************************************************************************************************/

// all tracking touch screen areas
typedef enum {
    NONE_PRESS,
    CURR_TEMP_PRESS,
    CURR_HUM_PRESS,
    MENU_PRESS,
} pressValues;

// all existing screens 
typedef enum {
    MENU_SCREEN,
    CURR_HUM_SCREEN,
    CURR_TEMP_SCREEN,
} screenValues;


/**************************************************************************************************************************
************************** User class for drawing at FT800 ****************************************************************
**************************************************************************************************************************/

class Display
{
public:
    // in Display class we use FT800 TFT (definition is available in main.cpp)
    Display(FT813 *TFT) {
        _TFT = TFT;
    }

    // functions describing all available screens (screens-functions)
    void MainMenu(float humidity, float temperature);   // [display.Draw_MainMenu.cpp]
    void CurrentHumidity(float humidity);               // [display.Draw_CurrentValuesGraphs.cpp]
    void CurrentTemperature(float temperature);         // [display.Draw_CurrentValuesGraphs.cpp]

    // functions using to prepare FT800
    void Calibration(void);                             // [display.Calibration.cpp]

    // functions for touch screen tracking
    char GetTouch(void);                                // [display.GetTouch.cpp]

    // variables using for navigation between screens
    char pressedButton;
    char activeScreen;

private:
    FT813 *_TFT;

    void StartDL(void);                                 // [display.DisplayListFunctions.cpp]
    void FinishDL(void);                                // [display.DisplayListFunctions.cpp]
    void MainMenuReference(void);                       // [display.Draw_MainMenuReference.cpp]
    void HorisontalGrid_CurrentTemp(void);              // [display.Draw_Grids.cpp]
    void HorisontalGrid_CurrentHumidity(void);          // [display.Draw_Grids.cpp]

    void CreateStringTempHum(char *str, float number, bool isTemp);       // [display.StringsTransforming.cpp]

    char humidityStr[8], temperatureStr[8];
    char currentHumidity_X, currentTemperature_X;
    char currentHumidity_Y[68], currentTemperature_Y[68];
};

#endif /* SCREENS_H_ */