#include "display.h"

/**************************************************************************************************************************
************************** Start display list *****************************************************************************
**************************************************************************************************************************/
void Display::StartDL()
{
    (*_TFT).DLstart();
    // set white color for background
    (*_TFT).DL(CLEAR_COLOR_RGB(255, 255, 255));
    // clear buffers for preset values
    (*_TFT).DL(CLEAR(1, 1, 1));
}

/**************************************************************************************************************************
************************** Finish display list ****************************************************************************
**************************************************************************************************************************/
void Display::FinishDL()
{
    (*_TFT).DL(DISPLAY());
    // Swap the current display list
    (*_TFT).Swap();
    // Download the command list into fifo TFT
    (*_TFT).Flush_Co_Buffer();
    //  Wait for the complete consumption of FT800 Coprocessor commands
    (*_TFT).WaitCmdfifo_empty();
}
            