#include "mbed.h"
#include "FT_Platform.h"
#include "HYT.h"
#include "display.h"
 
// NUCLEO-F429ZI
HYT SENSOR (D14, D15); // sda, scl
FT813 TFT (D11, D12, D13, D10, D9, D8); // mosi, miso, sck, ss, int, pd
 
Display disp(&TFT);
 
/**************************************************************************************************************************
************************** HYT sensor polling cycle ***********************************************************************
**************************************************************************************************************************/
void dataUpdate(void)
{
    SENSOR.MRCommand();
    wait_ms(100);
    SENSOR.DFCommand();
}
 
/**************************************************************************************************************************
************************** Main function **********************************************************************************
**************************************************************************************************************************/

int main()
{
    
    disp.Calibration();
 
    disp.activeScreen = MENU_SCREEN;
    disp.pressedButton = NONE_PRESS;
 
    // change active screen depending on pressed area
    while(1) {
        dataUpdate();
        disp.pressedButton = disp.GetTouch();
 
        // ----------------------------------------------------------------------------------------------
        // Main menu screen
        if (disp.activeScreen == MENU_SCREEN) {
            disp.MainMenu(SENSOR.humidity, SENSOR.temperature);
            if (disp.pressedButton) {
                wait_ms(150);
                if (disp.pressedButton == CURR_TEMP_PRESS) {
                    disp.activeScreen = CURR_TEMP_SCREEN;
                } else if (disp.pressedButton == CURR_HUM_PRESS) {
                    disp.activeScreen = CURR_HUM_SCREEN;
                } 
                disp.pressedButton = NONE_PRESS;
            }
 
        // ----------------------------------------------------------------------------------------------
        // Any other screen
        } else {
            // ----------------------------------------------------------------------------------------------
            // You can back to main menu from any screen
            if (disp.pressedButton == MENU_PRESS) {
                disp.pressedButton = NONE_PRESS;
                disp.activeScreen = MENU_SCREEN;
            } else {
                // ----------------------------------------------------------------------------------------------
                // Screen with current temperature / humidity
                if (disp.activeScreen == CURR_TEMP_SCREEN) {
                    disp.CurrentTemperature(SENSOR.temperature);
                } else if (disp.activeScreen == CURR_HUM_SCREEN) {
                    disp.CurrentHumidity(SENSOR.humidity);
                } 
            }
        }
    }
}
            