#ifndef LT1446_H
#define LT1446_H
/*Начало файла*/
#include "PerifConfig.h"

/*записывам в DACA и DACB а отправляем байты. Байт 2 содержит часть от обоих каналов*/
typedef union{
    struct{
        uint32_t
         DACB:12,
         DACA:12;
        };
        struct{
            uint8_t
        b3,
        b2,
        b1;
        };
    } LT1446_MEM_t;    //объявление типа
    //объявление внешней переменной (продолжение в cpp файле)
    extern LT1446_MEM_t LT1446_MEM;
 
 /*Оперативное значение калибровки*/
 typedef struct {
     float k,Volts,b;    
     struct{
     uint16_t Code:12; //вывод в ЦАП
     uint16_t       //резерв под флаги 
      f0:1,   
      f1:1,
      f2:1,
      f3:1;
     };
     }LT1446_Calibr_t;     

/*типа для создания экземпляра ЦАПа если их несколько*/
typedef struct {
    LT1446_Calibr_t dacA;
    LT1446_Calibr_t dacB;
    } LT1446_t;
    
    //объект по умолчанию
    extern LT1446_t LT1446_0;

     /*Функция калибровки (присвоение коэффициентов)*/
     void LT1446_CalibrateCh(LT1446_Calibr_t *dac,float k, float b);
     void LT1446_CalculateCh(LT1446_Calibr_t *dac);
     /*записать данные в память микросхемы*/
     void LT1446_Write(LT1446_t *chip);
     void LTCwrite(LT1446_t *chip);
/*Конец файла*/
#endif
