/*
 * flashwrapper.c
 *
 *      Author: spookee
 */

#include "stm32f4xx_hal.h"

#include "flashwrapper.h"


uint32_t flashRead(uint32_t address) {
    return (*(uint32_t*)(address+START_ADRESS));
}

void flashWrite(uint32_t address, uint32_t *p_data, uint16_t size) {	
	HAL_FLASH_Unlock();
	__HAL_FLASH_CLEAR_FLAG(FLASH_FLAG_EOP | FLASH_FLAG_OPERR | FLASH_FLAG_WRPERR | FLASH_FLAG_PGAERR | FLASH_FLAG_PGPERR);
	FLASH_Erase_Sector(FLASH_SECTOR_12, VOLTAGE_RANGE_3);
	for (int i = 0; i < size; i++) {
		HAL_FLASH_Program(FLASH_TYPEPROGRAM_WORD, START_ADRESS+address + i*4, p_data[i]);
	}
	HAL_FLASH_Lock();
}

